/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;

@SdkInternalApi
public class BatchGetItemRequestModelMarshaller {
    private static final MarshallingInfo<Map> REQUESTITEMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestItems").build();
    private static final MarshallingInfo<String> RETURNCONSUMEDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReturnConsumedCapacity").build();
    private static final BatchGetItemRequestModelMarshaller INSTANCE = new BatchGetItemRequestModelMarshaller();

    public static BatchGetItemRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchGetItemRequest batchGetItemRequest, ProtocolMarshaller protocolMarshaller) {
        if (batchGetItemRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(batchGetItemRequest.requestItems(), REQUESTITEMS_BINDING);
            protocolMarshaller.marshall((Object)batchGetItemRequest.returnConsumedCapacity(), RETURNCONSUMEDCAPACITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

