/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueListCopier;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.transform.ConditionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Condition
implements StructuredPojo,
ToCopyableBuilder<Builder, Condition> {
    private final List<AttributeValue> attributeValueList;
    private final String comparisonOperator;

    private Condition(BuilderImpl builder) {
        this.attributeValueList = builder.attributeValueList;
        this.comparisonOperator = builder.comparisonOperator;
    }

    public List<AttributeValue> attributeValueList() {
        return this.attributeValueList;
    }

    public String comparisonOperator() {
        return this.comparisonOperator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributeValueList() == null ? 0 : this.attributeValueList().hashCode());
        hashCode = 31 * hashCode + (this.comparisonOperator() == null ? 0 : this.comparisonOperator().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition)obj;
        if (other.attributeValueList() == null ^ this.attributeValueList() == null) {
            return false;
        }
        if (other.attributeValueList() != null && !other.attributeValueList().equals(this.attributeValueList())) {
            return false;
        }
        if (other.comparisonOperator() == null ^ this.comparisonOperator() == null) {
            return false;
        }
        return other.comparisonOperator() == null || other.comparisonOperator().equals(this.comparisonOperator());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attributeValueList() != null) {
            sb.append("AttributeValueList: ").append(this.attributeValueList()).append(",");
        }
        if (this.comparisonOperator() != null) {
            sb.append("ComparisonOperator: ").append(this.comparisonOperator()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConditionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<AttributeValue> attributeValueList;
        private String comparisonOperator;

        private BuilderImpl() {
        }

        private BuilderImpl(Condition model) {
            this.setAttributeValueList(model.attributeValueList);
            this.setComparisonOperator(model.comparisonOperator);
        }

        public final Collection<AttributeValue> getAttributeValueList() {
            return this.attributeValueList;
        }

        @Override
        public final Builder attributeValueList(Collection<AttributeValue> attributeValueList) {
            this.attributeValueList = AttributeValueListCopier.copy(attributeValueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValueList(AttributeValue ... attributeValueList) {
            this.attributeValueList(Arrays.asList(attributeValueList));
            return this;
        }

        public final void setAttributeValueList(Collection<AttributeValue> attributeValueList) {
            this.attributeValueList = AttributeValueListCopier.copy(attributeValueList);
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public Condition build() {
            return new Condition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Condition> {
        public Builder attributeValueList(Collection<AttributeValue> var1);

        public Builder attributeValueList(AttributeValue ... var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);
    }
}

