/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.spec;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.event.ProgressListener;
import software.amazon.awssdk.services.dynamodb.document.Expected;
import software.amazon.awssdk.services.dynamodb.document.Item;
import software.amazon.awssdk.services.dynamodb.document.spec.AbstractSpec;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;

public class PutItemSpec
extends AbstractSpec<PutItemRequest> {
    private Item item;
    private Collection<Expected> expected;
    private Map<String, String> nameMap;
    private Map<String, Object> valueMap;

    public PutItemSpec() {
        super((AmazonWebServiceRequest)PutItemRequest.builder().build());
    }

    public Item getItem() {
        return this.item;
    }

    public PutItemSpec withItem(Item item) {
        this.item = item;
        return this;
    }

    public Collection<Expected> getExpected() {
        return this.expected;
    }

    public PutItemSpec withExpected(Expected ... expected) {
        if (expected == null) {
            this.expected = null;
            return this;
        }
        return this.withExpected(Arrays.asList(expected));
    }

    public PutItemSpec withExpected(Collection<Expected> expected) {
        if (expected == null) {
            this.expected = null;
            return this;
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Expected e : expected) {
            names.add(e.getAttribute());
        }
        if (names.size() != expected.size()) {
            throw new IllegalArgumentException("attribute names must not duplicate in the list of expected");
        }
        this.expected = Collections.unmodifiableCollection(expected);
        return this;
    }

    public String getConditionExpression() {
        return ((PutItemRequest)((Object)this.getRequest())).conditionExpression();
    }

    public PutItemSpec withConditionExpression(String conditionExpression) {
        this.setRequest((AmazonWebServiceRequest)((PutItemRequest)((Object)this.getRequest())).toBuilder().conditionExpression(conditionExpression).build());
        return this;
    }

    public Map<String, String> nameMap() {
        return this.nameMap;
    }

    public PutItemSpec withNameMap(Map<String, String> nameMap) {
        this.nameMap = nameMap == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, String>(nameMap));
        return this;
    }

    public Map<String, Object> valueMap() {
        return this.valueMap;
    }

    public PutItemSpec valueMap(Map<String, Object> valueMap) {
        this.valueMap = valueMap == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(valueMap));
        return this;
    }

    public String getConditionalOperator() {
        return ((PutItemRequest)((Object)this.getRequest())).conditionalOperator();
    }

    public PutItemSpec withConditionalOperator(ConditionalOperator conditionalOperator) {
        this.setRequest((AmazonWebServiceRequest)((PutItemRequest)((Object)this.getRequest())).toBuilder().conditionalOperator(conditionalOperator).build());
        return this;
    }

    public String getReturnConsumedCapacity() {
        return ((PutItemRequest)((Object)this.getRequest())).returnConsumedCapacity();
    }

    public PutItemSpec withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.setRequest((AmazonWebServiceRequest)((PutItemRequest)((Object)this.getRequest())).toBuilder().returnConsumedCapacity(returnConsumedCapacity).build());
        return this;
    }

    public String getReturnItemCollectionMetrics() {
        return ((PutItemRequest)((Object)this.getRequest())).returnItemCollectionMetrics();
    }

    public PutItemSpec withReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
        this.setRequest((AmazonWebServiceRequest)((PutItemRequest)((Object)this.getRequest())).toBuilder().returnItemCollectionMetrics(returnItemCollectionMetrics).build());
        return this;
    }

    public String getReturnValues() {
        return ((PutItemRequest)((Object)this.getRequest())).returnValues();
    }

    public PutItemSpec withReturnValues(ReturnValue returnValues) {
        this.setRequest((AmazonWebServiceRequest)((PutItemRequest)((Object)this.getRequest())).toBuilder().returnValues(returnValues).build());
        return this;
    }

    public PutItemSpec withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }
}

