/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.document.Item;
import software.amazon.awssdk.services.dynamodb.document.Page;
import software.amazon.awssdk.services.dynamodb.document.ScanOutcome;
import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;
import software.amazon.awssdk.services.dynamodb.document.spec.ScanSpec;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

class ScanPage
extends Page<Item, ScanOutcome> {
    private final DynamoDBClient client;
    private final ScanSpec spec;
    private ScanRequest request;
    private final int index;
    private final Map<String, AttributeValue> lastEvaluatedKey;

    ScanPage(DynamoDBClient client, ScanSpec spec, ScanRequest request, int index, ScanOutcome outcome) {
        super(Collections.unmodifiableList(InternalUtils.toItemList(outcome.scanResult().items())), outcome);
        this.client = client;
        this.spec = spec;
        this.request = request;
        this.index = index;
        Integer max = spec.maxResultSize();
        ScanResponse result = outcome.scanResult();
        List<Map<String, AttributeValue>> ilist = result.items();
        int size = ilist == null ? 0 : ilist.size();
        this.lastEvaluatedKey = max != null && index + size > max ? null : result.lastEvaluatedKey();
    }

    @Override
    public boolean hasNextPage() {
        if (this.lastEvaluatedKey == null) {
            return false;
        }
        Integer max = this.spec.maxResultSize();
        if (max == null) {
            return true;
        }
        return this.nextRequestLimit(max) > 0;
    }

    private int nextRequestLimit(int max) {
        int nextIndex = this.index + this.size();
        return InternalUtils.minimum(max - nextIndex, this.spec.maxPageSize());
    }

    @Override
    public Page<Item, ScanOutcome> nextPage() {
        if (this.lastEvaluatedKey == null) {
            throw new NoSuchElementException("No more pages");
        }
        Integer max = this.spec.maxResultSize();
        if (max != null) {
            int nextLimit = this.nextRequestLimit(max);
            if (nextLimit == 0) {
                throw new NoSuchElementException("No more pages");
            }
            this.request = (ScanRequest)((Object)this.request.toBuilder().limit(nextLimit).build());
        }
        this.request = (ScanRequest)((Object)this.request.toBuilder().exclusiveStartKey(this.lastEvaluatedKey).build());
        ScanResponse result = this.client.scan(this.request);
        int nextIndex = this.index + this.size();
        return new ScanPage(this.client, this.spec, this.request, nextIndex, new ScanOutcome(result));
    }
}

