/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.internal;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dynamodb.document.AttributeUpdate;
import software.amazon.awssdk.services.dynamodb.document.Expected;
import software.amazon.awssdk.services.dynamodb.document.IncompatibleTypeException;
import software.amazon.awssdk.services.dynamodb.document.Item;
import software.amazon.awssdk.services.dynamodb.document.KeyAttribute;
import software.amazon.awssdk.services.dynamodb.document.PrimaryKey;
import software.amazon.awssdk.services.dynamodb.document.internal.Filter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;
import software.amazon.awssdk.utils.BinaryUtils;

public enum InternalUtils {


    public static List<Item> toItemList(List<Map<String, AttributeValue>> items) {
        if (items == null) {
            return Collections.emptyList();
        }
        ArrayList<Item> result = new ArrayList<Item>(items.size());
        for (Map<String, AttributeValue> item : items) {
            result.add(Item.fromMap(InternalUtils.toSimpleMapValue(item)));
        }
        return result;
    }

    public static Map<String, AttributeValue> toAttributeValues(Item item) {
        if (item == null) {
            return null;
        }
        LinkedHashMap<String, AttributeValue> result = new LinkedHashMap<String, AttributeValue>();
        for (Map.Entry<String, Object> entry : item.attributes()) {
            result.put(entry.getKey(), InternalUtils.toAttributeValue(entry.getValue()));
        }
        return result;
    }

    public static Map<String, AttributeValue> fromSimpleMap(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<String, AttributeValue> result = new LinkedHashMap<String, AttributeValue>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            result.put(entry.getKey(), InternalUtils.toAttributeValue(entry.getValue()));
        }
        return result;
    }

    public static Map<String, AttributeValueUpdate> toAttributeValueUpdate(List<AttributeUpdate> attributesToUpdate) {
        if (attributesToUpdate == null) {
            return null;
        }
        LinkedHashMap<String, AttributeValueUpdate> result = new LinkedHashMap<String, AttributeValueUpdate>();
        for (AttributeUpdate attribute : attributesToUpdate) {
            AttributeValueUpdate.Builder attributeToUpdateBuilder = AttributeValueUpdate.builder().action(attribute.getAction());
            if (attribute.value() != null) {
                attributeToUpdateBuilder.value(InternalUtils.toAttributeValue(attribute.value()));
            } else if (attribute.getAttributeValues() != null) {
                attributeToUpdateBuilder.value(InternalUtils.toAttributeValue(attribute.getAttributeValues()));
            }
            result.put(attribute.getAttributeName(), (AttributeValueUpdate)attributeToUpdateBuilder.build());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AttributeValue toAttributeValue(Object value) {
        AttributeValue.Builder resultBuilder = AttributeValue.builder();
        if (value == null) {
            return (AttributeValue)resultBuilder.nul(Boolean.TRUE).build();
        }
        if (value instanceof Boolean) {
            return (AttributeValue)resultBuilder.bool((Boolean)value).build();
        }
        if (value instanceof String) {
            return (AttributeValue)resultBuilder.s((String)value).build();
        }
        if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            return (AttributeValue)resultBuilder.n(bd.toPlainString()).build();
        }
        if (value instanceof Number) {
            return (AttributeValue)resultBuilder.n(value.toString()).build();
        }
        if (value instanceof byte[]) {
            return (AttributeValue)resultBuilder.b(ByteBuffer.wrap((byte[])value)).build();
        }
        if (value instanceof ByteBuffer) {
            return (AttributeValue)resultBuilder.b((ByteBuffer)value).build();
        }
        if (value instanceof Set) {
            Set set = (Set)value;
            if (set.size() == 0) {
                resultBuilder.ss(new ArrayList<String>());
                return (AttributeValue)resultBuilder.build();
            }
            Object element = set.iterator().next();
            if (element instanceof String) {
                Set ss = (Set)value;
                resultBuilder.ss(new ArrayList<String>(ss));
                return (AttributeValue)resultBuilder.build();
            } else if (element instanceof Number) {
                Set in = (Set)value;
                ArrayList<String> out = new ArrayList<String>(set.size());
                for (Number n : in) {
                    BigDecimal bd = InternalUtils.toBigDecimal(n);
                    out.add(bd.toPlainString());
                }
                resultBuilder.ns(out);
                return (AttributeValue)resultBuilder.build();
            } else if (element instanceof byte[]) {
                Set in = (Set)value;
                ArrayList<ByteBuffer> out = new ArrayList<ByteBuffer>(set.size());
                for (byte[] buf : in) {
                    out.add(ByteBuffer.wrap(buf));
                }
                resultBuilder.bs(out);
                return (AttributeValue)resultBuilder.build();
            } else {
                if (!(element instanceof ByteBuffer)) throw new UnsupportedOperationException("element type: " + element.getClass());
                Set bs = (Set)value;
                resultBuilder.bs(bs);
            }
            return (AttributeValue)resultBuilder.build();
        } else if (value instanceof List) {
            List in = (List)value;
            ArrayList<AttributeValue> out = new ArrayList<AttributeValue>();
            for (Object v : in) {
                out.add(InternalUtils.toAttributeValue(v));
            }
            resultBuilder.l(out);
            return (AttributeValue)resultBuilder.build();
        } else {
            if (!(value instanceof Map)) throw new UnsupportedOperationException("value type: " + value.getClass());
            Map in = (Map)value;
            HashMap<String, AttributeValue> attrs = new HashMap<String, AttributeValue>();
            for (Map.Entry e : in.entrySet()) {
                attrs.put((String)e.getKey(), InternalUtils.toAttributeValue(e.getValue()));
            }
            resultBuilder.m(attrs);
        }
        return (AttributeValue)resultBuilder.build();
    }

    public static List<Object> toSimpleList(List<AttributeValue> attrValues) {
        if (attrValues == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>(attrValues.size());
        for (AttributeValue attrValue : attrValues) {
            Object value = InternalUtils.toSimpleValue(attrValue);
            result.add(value);
        }
        return result;
    }

    public static <T> List<T> toSimpleListValue(List<AttributeValue> values) {
        if (values == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>(values.size());
        for (AttributeValue v : values) {
            T t = InternalUtils.toSimpleValue(v);
            result.add(t);
        }
        return result;
    }

    public static <T> Map<String, T> toSimpleMapValue(Map<String, AttributeValue> values) {
        if (values == null) {
            return null;
        }
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>(values.size());
        for (Map.Entry<String, AttributeValue> entry : values.entrySet()) {
            T t = InternalUtils.toSimpleValue(entry.getValue());
            result.put(entry.getKey(), t);
        }
        return result;
    }

    public static String valToString(Object val) {
        if (val instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)val;
            return bd.toPlainString();
        }
        if (val == null) {
            return null;
        }
        if (val instanceof String || val instanceof Boolean || val instanceof Number) {
            return val.toString();
        }
        throw new IncompatibleTypeException("Cannot convert " + val.getClass() + " into a string");
    }

    static <T> T toSimpleValue(AttributeValue value) {
        if (value == null) {
            return null;
        }
        if (Boolean.TRUE.equals(value.nul())) {
            return null;
        }
        if (Boolean.FALSE.equals(value.nul())) {
            throw new UnsupportedOperationException("False-NULL is not supported in DynamoDB");
        }
        if (value.bool() != null) {
            Boolean t = value.bool();
            return (T)t;
        }
        if (value.s() != null) {
            String t = value.s();
            return (T)t;
        }
        if (value.n() != null) {
            BigDecimal t = new BigDecimal(value.n());
            return (T)t;
        }
        if (value.b() != null) {
            byte[] t = BinaryUtils.copyAllBytesFrom((ByteBuffer)value.b());
            return (T)t;
        }
        if (value.ss() != null) {
            LinkedHashSet<String> t = new LinkedHashSet<String>(value.ss());
            return (T)t;
        }
        if (value.ns() != null) {
            LinkedHashSet<BigDecimal> set = new LinkedHashSet<BigDecimal>(value.ns().size());
            for (String s : value.ns()) {
                set.add(new BigDecimal(s));
            }
            LinkedHashSet<BigDecimal> t = set;
            return (T)t;
        }
        if (value.bs() != null) {
            LinkedHashSet<byte[]> set = new LinkedHashSet<byte[]>(value.bs().size());
            for (ByteBuffer bb : value.bs()) {
                set.add(BinaryUtils.copyAllBytesFrom((ByteBuffer)bb));
            }
            LinkedHashSet<byte[]> t = set;
            return (T)t;
        }
        if (value.l() != null) {
            List<Object> t = InternalUtils.toSimpleList(value.l());
            return (T)t;
        }
        if (value.m() != null) {
            Map<String, T> t = InternalUtils.toSimpleMapValue(value.m());
            return (T)t;
        }
        throw new IllegalArgumentException("Attribute value must not be empty: " + value);
    }

    public static Integer minimum(Integer one, Integer two) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        if (one < two) {
            return one;
        }
        return two;
    }

    public static Map<String, ExpectedAttributeValue> toExpectedAttributeValueMap(Collection<Expected> expectedSet) {
        if (expectedSet == null) {
            return null;
        }
        LinkedHashMap<String, Object> expectedMap = new LinkedHashMap<String, Object>();
        for (Expected expected : expectedSet) {
            ComparisonOperator op;
            String attr = expected.getAttribute();
            Object[] values = expected.values();
            ExpectedAttributeValue.Builder eavBuilder = ExpectedAttributeValue.builder();
            if (values != null) {
                if (values.length > 0) {
                    AttributeValue[] avs = InternalUtils.toAttributeValues(values);
                    eavBuilder.attributeValueList(avs);
                } else {
                    throw new IllegalStateException("Bug!");
                }
            }
            if ((op = expected.getComparisonOperator()) == null) {
                throw new IllegalArgumentException("Comparison operator for attribute " + expected.getAttribute() + " must be specified");
            }
            eavBuilder.comparisonOperator(op);
            expectedMap.put(attr, eavBuilder.build());
        }
        if (expectedSet.size() != expectedMap.size()) {
            throw new IllegalArgumentException("duplicates attribute names not allowed in input");
        }
        return Collections.unmodifiableMap(expectedMap);
    }

    public static Map<String, Condition> toAttributeConditionMap(Collection<? extends Filter<?>> filters) {
        if (filters == null) {
            return null;
        }
        LinkedHashMap<String, Object> conditionMap = new LinkedHashMap<String, Object>();
        for (Filter<?> filter : filters) {
            ComparisonOperator op;
            String attr = filter.getAttribute();
            Object[] values = filter.values();
            Condition.Builder conditionBuilder = Condition.builder();
            if (values != null) {
                if (values.length > 0) {
                    AttributeValue[] avs = InternalUtils.toAttributeValues(values);
                    conditionBuilder.attributeValueList(avs);
                } else {
                    throw new IllegalStateException("Bug!");
                }
            }
            if ((op = filter.getComparisonOperator()) == null) {
                throw new IllegalArgumentException("Comparison operator for attribute " + filter.getAttribute() + " must be specified");
            }
            conditionBuilder.comparisonOperator(op);
            conditionMap.put(attr, conditionBuilder.build());
        }
        if (filters.size() != conditionMap.size()) {
            throw new IllegalArgumentException("duplicates attribute names not allowed in input");
        }
        return Collections.unmodifiableMap(conditionMap);
    }

    public static AttributeValue[] toAttributeValues(Object[] values) {
        AttributeValue[] attrValues = new AttributeValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            attrValues[i] = InternalUtils.toAttributeValue(values[i]);
        }
        return attrValues;
    }

    public static Map<String, AttributeValue> toAttributeValueMap(Collection<KeyAttribute> primaryKey) {
        if (primaryKey == null) {
            return null;
        }
        LinkedHashMap<String, AttributeValue> keys = new LinkedHashMap<String, AttributeValue>();
        for (KeyAttribute keyAttr : primaryKey) {
            keys.put(keyAttr.name(), InternalUtils.toAttributeValue(keyAttr.value()));
        }
        return Collections.unmodifiableMap(keys);
    }

    public static Map<String, AttributeValue> toAttributeValueMap(PrimaryKey primaryKey) {
        if (primaryKey == null) {
            return null;
        }
        return InternalUtils.toAttributeValueMap(primaryKey.getComponents());
    }

    public static Map<String, AttributeValue> toAttributeValueMap(KeyAttribute ... primaryKey) {
        if (primaryKey == null) {
            return null;
        }
        return InternalUtils.toAttributeValueMap(Arrays.asList(primaryKey));
    }

    public static BigDecimal toBigDecimal(Number n) {
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        return new BigDecimal(n.toString());
    }

    public static Set<BigDecimal> toBigDecimalSet(Number ... val) {
        LinkedHashSet<BigDecimal> set = new LinkedHashSet<BigDecimal>(val.length);
        for (Number n : val) {
            set.add(InternalUtils.toBigDecimal(n));
        }
        return set;
    }

    public static Set<BigDecimal> toBigDecimalSet(Set<Number> vals) {
        LinkedHashSet<BigDecimal> set = new LinkedHashSet<BigDecimal>(vals.size());
        for (Number n : vals) {
            set.add(InternalUtils.toBigDecimal(n));
        }
        return set;
    }

    public static <X extends AmazonWebServiceRequest> X applyUserAgent(X request) {
        String userAgent = "dynamodb-table-api/2.0.0-preview-3";
        request.getRequestClientOptions().appendUserAgent("dynamodb-table-api/2.0.0-preview-3");
        return request;
    }

    public static void rejectNullValue(Object val) {
        if (val == null) {
            throw new IllegalArgumentException("Input value must not be null");
        }
    }

    public static void rejectNullInput(Object input) {
        if (input == null) {
            throw new IllegalArgumentException("Input must not be null");
        }
    }

    public static void rejectEmptyInput(Object[] input) {
        if (input.length == 0) {
            throw new IllegalArgumentException("At least one input must be specified");
        }
    }

    public static void rejectNullOrEmptyInput(Object[] input) {
        InternalUtils.rejectNullInput(input);
        InternalUtils.rejectEmptyInput(input);
    }

    public static void checkInvalidAttrName(String attrName) {
        if (attrName == null || attrName.trim().length() == 0) {
            throw new IllegalArgumentException("Attribute name must not be null or empty");
        }
    }

    public static void checkInvalidAttribute(String attrName, Object val) {
        InternalUtils.checkInvalidAttrName(attrName);
        InternalUtils.rejectNullValue(val);
    }
}

