/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.document.BatchGetItemOutcome;
import software.amazon.awssdk.services.dynamodb.document.PrimaryKey;
import software.amazon.awssdk.services.dynamodb.document.TableKeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.document.api.BatchGetItemApi;
import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;
import software.amazon.awssdk.services.dynamodb.document.spec.BatchGetItemSpec;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;

public class BatchGetItemImpl
implements BatchGetItemApi {
    private final DynamoDBClient client;

    public BatchGetItemImpl(DynamoDBClient client) {
        this.client = client;
    }

    @Override
    public BatchGetItemOutcome batchGetItem(ReturnConsumedCapacity returnConsumedCapacity, TableKeysAndAttributes ... tableKeysAndAttributes) {
        return this.doBatchGetItem(new BatchGetItemSpec().withReturnConsumedCapacity(returnConsumedCapacity).withTableKeyAndAttributes(tableKeysAndAttributes));
    }

    @Override
    public BatchGetItemOutcome batchGetItem(TableKeysAndAttributes ... tableKeysAndAttributes) {
        return this.doBatchGetItem(new BatchGetItemSpec().withTableKeyAndAttributes(tableKeysAndAttributes));
    }

    @Override
    public BatchGetItemOutcome batchGetItem(BatchGetItemSpec spec) {
        return this.doBatchGetItem(spec);
    }

    private BatchGetItemOutcome doBatchGetItem(BatchGetItemSpec spec) {
        Collection<TableKeysAndAttributes> tableKeysAndAttributesCol = spec.getTableKeysAndAttributes();
        Map<String, KeysAndAttributes> requestItems = spec.getUnprocessedKeys();
        if (requestItems == null || requestItems.size() == 0) {
            requestItems = new LinkedHashMap<String, KeysAndAttributes>();
        }
        if (tableKeysAndAttributesCol != null) {
            for (TableKeysAndAttributes tableKeysAndAttributes : tableKeysAndAttributesCol) {
                Set<String> attrNames = tableKeysAndAttributes.getAttributeNames();
                List<PrimaryKey> pks = tableKeysAndAttributes.getPrimaryKeys();
                ArrayList<Map<String, AttributeValue>> keys = new ArrayList<Map<String, AttributeValue>>(pks.size());
                for (PrimaryKey pk : pks) {
                    keys.add(InternalUtils.toAttributeValueMap(pk));
                }
                KeysAndAttributes keysAndAttrs = (KeysAndAttributes)KeysAndAttributes.builder().attributesToGet(attrNames).consistentRead(tableKeysAndAttributes.isConsistentRead()).keys(keys).projectionExpression(tableKeysAndAttributes.getProjectionExpression()).expressionAttributeNames(tableKeysAndAttributes.nameMap()).build();
                requestItems.put(tableKeysAndAttributes.getTableName(), keysAndAttrs);
            }
        }
        BatchGetItemRequest req = (BatchGetItemRequest)((Object)((BatchGetItemRequest)((Object)spec.getRequest())).toBuilder().requestItems(requestItems).build());
        spec.setRequest(req);
        BatchGetItemResponse result = this.client.batchGetItem(req);
        return new BatchGetItemOutcome(result);
    }

    @Override
    public BatchGetItemOutcome batchGetItemUnprocessed(ReturnConsumedCapacity returnConsumedCapacity, Map<String, KeysAndAttributes> unprocessedKeys) {
        return this.doBatchGetItem(new BatchGetItemSpec().withReturnConsumedCapacity(returnConsumedCapacity).withUnprocessedKeys(unprocessedKeys));
    }

    @Override
    public BatchGetItemOutcome batchGetItemUnprocessed(Map<String, KeysAndAttributes> unprocessedKeys) {
        return this.doBatchGetItem(new BatchGetItemSpec().withUnprocessedKeys(unprocessedKeys));
    }
}

