/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.ResourceInUseException;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;

public class TableUtils {
    private static final int DEFAULT_WAIT_TIMEOUT = 600000;
    private static final int DEFAULT_WAIT_INTERVAL = 20000;
    private static final Logger log = LoggerFactory.getLogger(TableUtils.class);

    public static void waitUntilExists(DynamoDBClient dynamo, String tableName) throws InterruptedException {
        TableUtils.waitUntilExists(dynamo, tableName, 600000, 20000);
    }

    public static void waitUntilExists(DynamoDBClient dynamo, String tableName, int timeout, int interval) throws InterruptedException {
        TableDescription table = TableUtils.waitForTableDescription(dynamo, tableName, null, timeout, interval);
        if (table == null) {
            throw new SdkClientException("Table " + tableName + " never returned a result");
        }
    }

    public static void waitUntilActive(DynamoDBClient dynamo, String tableName) throws InterruptedException, TableNeverTransitionedToStateException {
        TableUtils.waitUntilActive(dynamo, tableName, 600000, 20000);
    }

    public static void waitUntilActive(DynamoDBClient dynamo, String tableName, int timeout, int interval) throws InterruptedException, TableNeverTransitionedToStateException {
        TableDescription table = TableUtils.waitForTableDescription(dynamo, tableName, TableStatus.ACTIVE, timeout, interval);
        if (table == null || !table.tableStatus().equals(TableStatus.ACTIVE.toString())) {
            throw new TableNeverTransitionedToStateException(tableName, TableStatus.ACTIVE);
        }
    }

    private static TableDescription waitForTableDescription(DynamoDBClient dynamo, String tableName, TableStatus desiredStatus, int timeout, int interval) throws InterruptedException, IllegalArgumentException {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout must be >= 0");
        }
        if (interval <= 0 || interval >= timeout) {
            throw new IllegalArgumentException("Interval must be > 0 and < timeout");
        }
        long startTime = System.currentTimeMillis();
        long endTime = startTime + (long)timeout;
        TableDescription table = null;
        while (System.currentTimeMillis() < endTime) {
            try {
                table = dynamo.describeTable((DescribeTableRequest)((Object)DescribeTableRequest.builder().tableName(tableName).build())).table();
                if (desiredStatus == null || table.tableStatus().equals(desiredStatus.toString())) {
                    return table;
                }
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                // empty catch block
            }
            Thread.sleep(interval);
        }
        return table;
    }

    public static boolean createTableIfNotExists(DynamoDBClient dynamo, CreateTableRequest createTableRequest) {
        try {
            dynamo.createTable(createTableRequest);
            return true;
        }
        catch (ResourceInUseException e) {
            if (log.isTraceEnabled()) {
                log.trace("Table " + createTableRequest.tableName() + " already exists", (Throwable)((Object)e));
            }
            return false;
        }
    }

    public static boolean deleteTableIfExists(DynamoDBClient dynamo, DeleteTableRequest deleteTableRequest) {
        try {
            dynamo.deleteTable(deleteTableRequest);
            return true;
        }
        catch (ResourceNotFoundException e) {
            if (log.isTraceEnabled()) {
                log.trace("Table " + deleteTableRequest.tableName() + " does not exist", (Throwable)((Object)e));
            }
            return false;
        }
    }

    public static class TableNeverTransitionedToStateException
    extends SdkClientException {
        private static final long serialVersionUID = 8920567021104846647L;

        public TableNeverTransitionedToStateException(String tableName, TableStatus desiredStatus) {
            super("Table " + tableName + " never transitioned to desired state of " + desiredStatus.toString());
        }
    }
}

