/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.transform.LocalSecondaryIndexDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LocalSecondaryIndexDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, LocalSecondaryIndexDescription> {
    private final String indexName;
    private final List<KeySchemaElement> keySchema;
    private final Projection projection;
    private final Long indexSizeBytes;
    private final Long itemCount;
    private final String indexArn;

    private LocalSecondaryIndexDescription(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.keySchema = builder.keySchema;
        this.projection = builder.projection;
        this.indexSizeBytes = builder.indexSizeBytes;
        this.itemCount = builder.itemCount;
        this.indexArn = builder.indexArn;
    }

    public String indexName() {
        return this.indexName;
    }

    public List<KeySchemaElement> keySchema() {
        return this.keySchema;
    }

    public Projection projection() {
        return this.projection;
    }

    public Long indexSizeBytes() {
        return this.indexSizeBytes;
    }

    public Long itemCount() {
        return this.itemCount;
    }

    public String indexArn() {
        return this.indexArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.indexName() == null ? 0 : this.indexName().hashCode());
        hashCode = 31 * hashCode + (this.keySchema() == null ? 0 : this.keySchema().hashCode());
        hashCode = 31 * hashCode + (this.projection() == null ? 0 : this.projection().hashCode());
        hashCode = 31 * hashCode + (this.indexSizeBytes() == null ? 0 : this.indexSizeBytes().hashCode());
        hashCode = 31 * hashCode + (this.itemCount() == null ? 0 : this.itemCount().hashCode());
        hashCode = 31 * hashCode + (this.indexArn() == null ? 0 : this.indexArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalSecondaryIndexDescription)) {
            return false;
        }
        LocalSecondaryIndexDescription other = (LocalSecondaryIndexDescription)obj;
        if (other.indexName() == null ^ this.indexName() == null) {
            return false;
        }
        if (other.indexName() != null && !other.indexName().equals(this.indexName())) {
            return false;
        }
        if (other.keySchema() == null ^ this.keySchema() == null) {
            return false;
        }
        if (other.keySchema() != null && !other.keySchema().equals(this.keySchema())) {
            return false;
        }
        if (other.projection() == null ^ this.projection() == null) {
            return false;
        }
        if (other.projection() != null && !other.projection().equals(this.projection())) {
            return false;
        }
        if (other.indexSizeBytes() == null ^ this.indexSizeBytes() == null) {
            return false;
        }
        if (other.indexSizeBytes() != null && !other.indexSizeBytes().equals(this.indexSizeBytes())) {
            return false;
        }
        if (other.itemCount() == null ^ this.itemCount() == null) {
            return false;
        }
        if (other.itemCount() != null && !other.itemCount().equals(this.itemCount())) {
            return false;
        }
        if (other.indexArn() == null ^ this.indexArn() == null) {
            return false;
        }
        return other.indexArn() == null || other.indexArn().equals(this.indexArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.indexName() != null) {
            sb.append("IndexName: ").append(this.indexName()).append(",");
        }
        if (this.keySchema() != null) {
            sb.append("KeySchema: ").append(this.keySchema()).append(",");
        }
        if (this.projection() != null) {
            sb.append("Projection: ").append(this.projection()).append(",");
        }
        if (this.indexSizeBytes() != null) {
            sb.append("IndexSizeBytes: ").append(this.indexSizeBytes()).append(",");
        }
        if (this.itemCount() != null) {
            sb.append("ItemCount: ").append(this.itemCount()).append(",");
        }
        if (this.indexArn() != null) {
            sb.append("IndexArn: ").append(this.indexArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LocalSecondaryIndexDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String indexName;
        private List<KeySchemaElement> keySchema;
        private Projection projection;
        private Long indexSizeBytes;
        private Long itemCount;
        private String indexArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LocalSecondaryIndexDescription model) {
            this.setIndexName(model.indexName);
            this.setKeySchema(model.keySchema);
            this.setProjection(model.projection);
            this.setIndexSizeBytes(model.indexSizeBytes);
            this.setItemCount(model.itemCount);
            this.setIndexArn(model.indexArn);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final Collection<KeySchemaElement> getKeySchema() {
            return this.keySchema;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
        }

        @SafeVarargs
        public final void setKeySchema(KeySchemaElement ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
        }

        public final Projection getProjection() {
            return this.projection;
        }

        @Override
        public final Builder projection(Projection projection) {
            this.projection = projection;
            return this;
        }

        public final void setProjection(Projection projection) {
            this.projection = projection;
        }

        public final Long getIndexSizeBytes() {
            return this.indexSizeBytes;
        }

        @Override
        public final Builder indexSizeBytes(Long indexSizeBytes) {
            this.indexSizeBytes = indexSizeBytes;
            return this;
        }

        public final void setIndexSizeBytes(Long indexSizeBytes) {
            this.indexSizeBytes = indexSizeBytes;
        }

        public final Long getItemCount() {
            return this.itemCount;
        }

        @Override
        public final Builder itemCount(Long itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final void setItemCount(Long itemCount) {
            this.itemCount = itemCount;
        }

        public final String getIndexArn() {
            return this.indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        public LocalSecondaryIndexDescription build() {
            return new LocalSecondaryIndexDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LocalSecondaryIndexDescription> {
        public Builder indexName(String var1);

        public Builder keySchema(Collection<KeySchemaElement> var1);

        public Builder keySchema(KeySchemaElement ... var1);

        public Builder projection(Projection var1);

        public Builder indexSizeBytes(Long var1);

        public Builder itemCount(Long var1);

        public Builder indexArn(String var1);
    }
}

