/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequestMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchWriteItemRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BatchWriteItemRequest> {
    private final Map<String, List<WriteRequest>> requestItems;
    private final String returnConsumedCapacity;
    private final String returnItemCollectionMetrics;

    private BatchWriteItemRequest(BuilderImpl builder) {
        this.requestItems = builder.requestItems;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.returnItemCollectionMetrics = builder.returnItemCollectionMetrics;
    }

    public Map<String, List<WriteRequest>> requestItems() {
        return this.requestItems;
    }

    public String returnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public String returnItemCollectionMetrics() {
        return this.returnItemCollectionMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.requestItems() == null ? 0 : this.requestItems().hashCode());
        hashCode = 31 * hashCode + (this.returnConsumedCapacity() == null ? 0 : this.returnConsumedCapacity().hashCode());
        hashCode = 31 * hashCode + (this.returnItemCollectionMetrics() == null ? 0 : this.returnItemCollectionMetrics().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteItemRequest)) {
            return false;
        }
        BatchWriteItemRequest other = (BatchWriteItemRequest)((Object)obj);
        if (other.requestItems() == null ^ this.requestItems() == null) {
            return false;
        }
        if (other.requestItems() != null && !other.requestItems().equals(this.requestItems())) {
            return false;
        }
        if (other.returnConsumedCapacity() == null ^ this.returnConsumedCapacity() == null) {
            return false;
        }
        if (other.returnConsumedCapacity() != null && !other.returnConsumedCapacity().equals(this.returnConsumedCapacity())) {
            return false;
        }
        if (other.returnItemCollectionMetrics() == null ^ this.returnItemCollectionMetrics() == null) {
            return false;
        }
        return other.returnItemCollectionMetrics() == null || other.returnItemCollectionMetrics().equals(this.returnItemCollectionMetrics());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.requestItems() != null) {
            sb.append("RequestItems: ").append(this.requestItems()).append(",");
        }
        if (this.returnConsumedCapacity() != null) {
            sb.append("ReturnConsumedCapacity: ").append(this.returnConsumedCapacity()).append(",");
        }
        if (this.returnItemCollectionMetrics() != null) {
            sb.append("ReturnItemCollectionMetrics: ").append(this.returnItemCollectionMetrics()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Map<String, List<WriteRequest>> requestItems;
        private String returnConsumedCapacity;
        private String returnItemCollectionMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteItemRequest model) {
            this.setRequestItems(model.requestItems);
            this.setReturnConsumedCapacity(model.returnConsumedCapacity);
            this.setReturnItemCollectionMetrics(model.returnItemCollectionMetrics);
        }

        public final Map<String, ? extends Collection<WriteRequest>> getRequestItems() {
            return this.requestItems;
        }

        @Override
        public final Builder requestItems(Map<String, ? extends Collection<WriteRequest>> requestItems) {
            this.requestItems = BatchWriteItemRequestMapCopier.copy(requestItems);
            return this;
        }

        public final void setRequestItems(Map<String, ? extends Collection<WriteRequest>> requestItems) {
            this.requestItems = BatchWriteItemRequestMapCopier.copy(requestItems);
        }

        public final String getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
        }

        public final String getReturnItemCollectionMetrics() {
            return this.returnItemCollectionMetrics;
        }

        @Override
        public final Builder returnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        @Override
        public final Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics(returnItemCollectionMetrics.toString());
            return this;
        }

        public final void setReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
        }

        public final void setReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics(returnItemCollectionMetrics.toString());
        }

        public BatchWriteItemRequest build() {
            return new BatchWriteItemRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchWriteItemRequest> {
        public Builder requestItems(Map<String, ? extends Collection<WriteRequest>> var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);

        public Builder returnItemCollectionMetrics(String var1);

        public Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics var1);
    }
}

