/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.document.BatchWriteItemOutcome;
import software.amazon.awssdk.services.dynamodb.document.Item;
import software.amazon.awssdk.services.dynamodb.document.PrimaryKey;
import software.amazon.awssdk.services.dynamodb.document.TableWriteItems;
import software.amazon.awssdk.services.dynamodb.document.api.BatchWriteItemApi;
import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;
import software.amazon.awssdk.services.dynamodb.document.spec.BatchWriteItemSpec;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

public class BatchWriteItemImpl
implements BatchWriteItemApi {
    private final DynamoDBClient client;

    public BatchWriteItemImpl(DynamoDBClient client) {
        this.client = client;
    }

    @Override
    public BatchWriteItemOutcome batchWriteItem(TableWriteItems ... tableWriteItems) {
        return this.doBatchWriteItem(new BatchWriteItemSpec().withTableWriteItems(tableWriteItems));
    }

    @Override
    public BatchWriteItemOutcome batchWriteItem(BatchWriteItemSpec spec) {
        return this.doBatchWriteItem(spec);
    }

    @Override
    public BatchWriteItemOutcome batchWriteItemUnprocessed(Map<String, List<WriteRequest>> unprocessedItems) {
        return this.doBatchWriteItem(new BatchWriteItemSpec().withUnprocessedItems(unprocessedItems));
    }

    private BatchWriteItemOutcome doBatchWriteItem(BatchWriteItemSpec spec) {
        Collection<TableWriteItems> tableWriteItemsCol = spec.getTableWriteItems();
        Map<String, List<WriteRequest>> requestItems = spec.getUnprocessedItems();
        if (requestItems == null || requestItems.size() == 0) {
            requestItems = new LinkedHashMap<String, List<WriteRequest>>();
        }
        if (tableWriteItemsCol != null) {
            for (TableWriteItems tableWriteItems : tableWriteItemsCol) {
                Collection<Item> itemsToPut = tableWriteItems.getItemsToPut();
                List<PrimaryKey> pksToDelete = tableWriteItems.getPrimaryKeysToDelete();
                int numPut = itemsToPut == null ? 0 : itemsToPut.size();
                int numDel = pksToDelete == null ? 0 : pksToDelete.size();
                ArrayList<Object> writeRequests = new ArrayList<Object>(numPut + numDel);
                if (itemsToPut != null) {
                    for (Item item : itemsToPut) {
                        writeRequests.add(WriteRequest.builder().putRequest((PutRequest)PutRequest.builder().item(InternalUtils.toAttributeValues(item)).build()).build());
                    }
                }
                if (pksToDelete != null) {
                    for (PrimaryKey pkToDelete : pksToDelete) {
                        writeRequests.add(WriteRequest.builder().deleteRequest((DeleteRequest)DeleteRequest.builder().key(InternalUtils.toAttributeValueMap(pkToDelete)).build()).build());
                    }
                }
                requestItems.put(tableWriteItems.getTableName(), writeRequests);
            }
        }
        BatchWriteItemRequest req = (BatchWriteItemRequest)((Object)((BatchWriteItemRequest)((Object)spec.getRequest())).toBuilder().requestItems(requestItems).build());
        BatchWriteItemResponse result = this.client.batchWriteItem(req);
        return new BatchWriteItemOutcome(result);
    }
}

