/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.DynamoDBClientBuilder;
import software.amazon.awssdk.services.dynamodb.document.BatchGetItemOutcome;
import software.amazon.awssdk.services.dynamodb.document.BatchWriteItemOutcome;
import software.amazon.awssdk.services.dynamodb.document.Table;
import software.amazon.awssdk.services.dynamodb.document.TableCollection;
import software.amazon.awssdk.services.dynamodb.document.TableKeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.document.TableWriteItems;
import software.amazon.awssdk.services.dynamodb.document.api.BatchGetItemApi;
import software.amazon.awssdk.services.dynamodb.document.api.BatchWriteItemApi;
import software.amazon.awssdk.services.dynamodb.document.api.ListTablesApi;
import software.amazon.awssdk.services.dynamodb.document.internal.BatchGetItemImpl;
import software.amazon.awssdk.services.dynamodb.document.internal.BatchWriteItemImpl;
import software.amazon.awssdk.services.dynamodb.document.internal.ListTablesImpl;
import software.amazon.awssdk.services.dynamodb.document.spec.BatchGetItemSpec;
import software.amazon.awssdk.services.dynamodb.document.spec.BatchWriteItemSpec;
import software.amazon.awssdk.services.dynamodb.document.spec.ListTablesSpec;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@ThreadSafe
public class DynamoDb
implements ListTablesApi,
BatchGetItemApi,
BatchWriteItemApi {
    private final DynamoDBClient client;
    private final ListTablesImpl listTablesDelegate;
    private final BatchGetItemImpl batchGetItemDelegate;
    private final BatchWriteItemImpl batchWriteItemDelegate;

    public DynamoDb(DynamoDBClient client) {
        if (client == null) {
            throw new IllegalArgumentException();
        }
        this.client = client;
        this.listTablesDelegate = new ListTablesImpl(client);
        this.batchGetItemDelegate = new BatchGetItemImpl(client);
        this.batchWriteItemDelegate = new BatchWriteItemImpl(client);
    }

    public DynamoDb(Region regionEnum) {
        this((DynamoDBClient)((DynamoDBClientBuilder)DynamoDBClient.builder().region(regionEnum)).build());
    }

    public Table getTable(String tableName) {
        return new Table(this.client, tableName);
    }

    public Table createTable(CreateTableRequest req) {
        CreateTableResponse result = this.client.createTable(req);
        return new Table(this.client, req.tableName(), result.tableDescription());
    }

    public Table createTable(String tableName, List<KeySchemaElement> keySchema, List<AttributeDefinition> attributeDefinitions, ProvisionedThroughput provisionedThroughput) {
        return this.createTable((CreateTableRequest)((Object)CreateTableRequest.builder().tableName(tableName).keySchema(keySchema).attributeDefinitions(attributeDefinitions).provisionedThroughput(provisionedThroughput).build()));
    }

    @Override
    public TableCollection<ListTablesResponse> listTables() {
        return this.listTablesDelegate.listTables();
    }

    @Override
    public TableCollection<ListTablesResponse> listTables(String exclusiveStartTableName) {
        return this.listTablesDelegate.listTables(exclusiveStartTableName);
    }

    @Override
    public TableCollection<ListTablesResponse> listTables(String exclusiveStartTableName, int maxResultSize) {
        return this.listTablesDelegate.listTables(exclusiveStartTableName, maxResultSize);
    }

    @Override
    public TableCollection<ListTablesResponse> listTables(int maxResultSize) {
        return this.listTablesDelegate.listTables(maxResultSize);
    }

    @Override
    public TableCollection<ListTablesResponse> listTables(ListTablesSpec spec) {
        return this.listTablesDelegate.listTables(spec);
    }

    @Override
    public BatchGetItemOutcome batchGetItem(ReturnConsumedCapacity returnConsumedCapacity, TableKeysAndAttributes ... tableKeysAndAttributes) {
        return this.batchGetItemDelegate.batchGetItem(returnConsumedCapacity, tableKeysAndAttributes);
    }

    @Override
    public BatchGetItemOutcome batchGetItem(TableKeysAndAttributes ... tableKeysAndAttributes) {
        return this.batchGetItemDelegate.batchGetItem(tableKeysAndAttributes);
    }

    @Override
    public BatchGetItemOutcome batchGetItem(BatchGetItemSpec spec) {
        return this.batchGetItemDelegate.batchGetItem(spec);
    }

    @Override
    public BatchGetItemOutcome batchGetItemUnprocessed(ReturnConsumedCapacity returnConsumedCapacity, Map<String, KeysAndAttributes> unprocessedKeys) {
        return this.batchGetItemDelegate.batchGetItemUnprocessed(returnConsumedCapacity, unprocessedKeys);
    }

    @Override
    public BatchGetItemOutcome batchGetItemUnprocessed(Map<String, KeysAndAttributes> unprocessedKeys) {
        return this.batchGetItemDelegate.batchGetItemUnprocessed(unprocessedKeys);
    }

    @Override
    public BatchWriteItemOutcome batchWriteItem(TableWriteItems ... tableWriteItems) {
        return this.batchWriteItemDelegate.batchWriteItem(tableWriteItems);
    }

    @Override
    public BatchWriteItemOutcome batchWriteItem(BatchWriteItemSpec spec) {
        return this.batchWriteItemDelegate.batchWriteItem(spec);
    }

    @Override
    public BatchWriteItemOutcome batchWriteItemUnprocessed(Map<String, List<WriteRequest>> unprocessedItems) {
        return this.batchWriteItemDelegate.batchWriteItemUnprocessed(unprocessedItems);
    }

    public void shutdown() throws Exception {
        this.client.close();
    }
}

