/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.metrics.RequestMetricCollector;
import software.amazon.awssdk.services.dynamodb.datamodeling.BatchLoadContext;
import software.amazon.awssdk.services.dynamodb.datamodeling.ConversionSchema;
import software.amazon.awssdk.services.dynamodb.datamodeling.ConversionSchemas;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMappingException;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverterFactory;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardBeanProperties;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

public class DynamoDbMapperConfig {
    public static final DynamoDbMapperConfig DEFAULT = DynamoDbMapperConfig.builder().withSaveBehavior(SaveBehavior.UPDATE).withConsistentReads(ConsistentReads.EVENTUAL).withPaginationLoadingStrategy(PaginationLoadingStrategy.LAZY_LOADING).withTableNameResolver(DefaultTableNameResolver.INSTANCE).withBatchWriteRetryStrategy(DefaultBatchWriteRetryStrategy.INSTANCE).withBatchLoadRetryStrategy(DefaultBatchLoadRetryStrategy.INSTANCE).withTypeConverterFactory(DynamoDbTypeConverterFactory.standard()).withConversionSchema(ConversionSchemas.DEFAULT).build();
    private final SaveBehavior saveBehavior;
    private final ConsistentReads consistentReads;
    private final TableNameOverride tableNameOverride;
    private final TableNameResolver tableNameResolver;
    private final ObjectTableNameResolver objectTableNameResolver;
    private final PaginationLoadingStrategy paginationLoadingStrategy;
    private final RequestMetricCollector requestMetricCollector;
    private final ConversionSchema conversionschema;
    private final BatchWriteRetryStrategy batchWriteRetryStrategy;
    private final BatchLoadRetryStrategy batchLoadRetryStrategy;
    private final DynamoDbTypeConverterFactory typeConverterFactory;

    private DynamoDbMapperConfig(Builder builder) {
        this.saveBehavior = builder.saveBehavior;
        this.consistentReads = builder.consistentReads;
        this.tableNameOverride = builder.tableNameOverride;
        this.tableNameResolver = builder.tableNameResolver;
        this.objectTableNameResolver = builder.objectTableNameResolver;
        this.paginationLoadingStrategy = builder.paginationLoadingStrategy;
        this.requestMetricCollector = builder.requestMetricCollector;
        this.conversionschema = builder.conversionschema;
        this.batchWriteRetryStrategy = builder.batchWriteRetryStrategy;
        this.batchLoadRetryStrategy = builder.batchLoadRetryStrategy;
        this.typeConverterFactory = builder.typeConverterFactory;
    }

    @Deprecated
    public DynamoDbMapperConfig(SaveBehavior saveBehavior, ConsistentReads consistentReads, TableNameOverride tableNameOverride) {
        this(saveBehavior, consistentReads, tableNameOverride, null, null);
    }

    @Deprecated
    public DynamoDbMapperConfig(SaveBehavior saveBehavior, ConsistentReads consistentReads, TableNameOverride tableNameOverride, PaginationLoadingStrategy paginationLoadingStrategy) {
        this(saveBehavior, consistentReads, tableNameOverride, paginationLoadingStrategy, null);
    }

    @Deprecated
    public DynamoDbMapperConfig(SaveBehavior saveBehavior, ConsistentReads consistentReads, TableNameOverride tableNameOverride, PaginationLoadingStrategy paginationLoadingStrategy, RequestMetricCollector requestMetricCollector) {
        this(saveBehavior, consistentReads, tableNameOverride, null, null, paginationLoadingStrategy, requestMetricCollector, DEFAULT.getConversionSchema(), DEFAULT.batchWriteRetryStrategy(), DEFAULT.batchLoadRetryStrategy());
    }

    private DynamoDbMapperConfig(SaveBehavior saveBehavior, ConsistentReads consistentReads, TableNameOverride tableNameOverride, TableNameResolver tableNameResolver, ObjectTableNameResolver objectTableNameResolver, PaginationLoadingStrategy paginationLoadingStrategy, RequestMetricCollector requestMetricCollector, ConversionSchema conversionschema, BatchWriteRetryStrategy batchWriteRetryStrategy, BatchLoadRetryStrategy batchLoadRetryStrategy) {
        this.saveBehavior = saveBehavior;
        this.consistentReads = consistentReads;
        this.tableNameOverride = tableNameOverride;
        this.tableNameResolver = tableNameResolver;
        this.objectTableNameResolver = objectTableNameResolver;
        this.paginationLoadingStrategy = paginationLoadingStrategy;
        this.requestMetricCollector = requestMetricCollector;
        this.conversionschema = conversionschema;
        this.batchWriteRetryStrategy = batchWriteRetryStrategy;
        this.batchLoadRetryStrategy = batchLoadRetryStrategy;
        this.typeConverterFactory = null;
    }

    @Deprecated
    public DynamoDbMapperConfig(SaveBehavior saveBehavior) {
        this(saveBehavior, null, null, null, null, null, null, DEFAULT.getConversionSchema(), DEFAULT.batchWriteRetryStrategy(), DEFAULT.batchLoadRetryStrategy());
    }

    @Deprecated
    public DynamoDbMapperConfig(ConsistentReads consistentReads) {
        this(null, consistentReads, null, null, null, null, null, DEFAULT.getConversionSchema(), DEFAULT.batchWriteRetryStrategy(), DEFAULT.batchLoadRetryStrategy());
    }

    @Deprecated
    public DynamoDbMapperConfig(TableNameOverride tableNameOverride) {
        this(null, null, tableNameOverride, null, null, null, null, DEFAULT.getConversionSchema(), DEFAULT.batchWriteRetryStrategy(), DEFAULT.batchLoadRetryStrategy());
    }

    @Deprecated
    public DynamoDbMapperConfig(TableNameResolver tableNameResolver) {
        this(null, null, null, tableNameResolver, null, null, null, DEFAULT.getConversionSchema(), DEFAULT.batchWriteRetryStrategy(), DEFAULT.batchLoadRetryStrategy());
    }

    @Deprecated
    public DynamoDbMapperConfig(ObjectTableNameResolver objectTableNameResolver) {
        this(null, null, null, null, objectTableNameResolver, null, null, DEFAULT.getConversionSchema(), DEFAULT.batchWriteRetryStrategy(), DEFAULT.batchLoadRetryStrategy());
    }

    @Deprecated
    public DynamoDbMapperConfig(TableNameResolver tableNameResolver, ObjectTableNameResolver objectTableNameResolver) {
        this(null, null, null, tableNameResolver, objectTableNameResolver, null, null, DEFAULT.getConversionSchema(), DEFAULT.batchWriteRetryStrategy(), DEFAULT.batchLoadRetryStrategy());
    }

    @Deprecated
    public DynamoDbMapperConfig(PaginationLoadingStrategy paginationLoadingStrategy) {
        this(null, null, null, null, null, paginationLoadingStrategy, null, DEFAULT.getConversionSchema(), DEFAULT.batchWriteRetryStrategy(), DEFAULT.batchLoadRetryStrategy());
    }

    @Deprecated
    public DynamoDbMapperConfig(ConversionSchema conversionschema) {
        this(null, null, null, null, null, null, null, conversionschema, DEFAULT.batchWriteRetryStrategy(), DEFAULT.batchLoadRetryStrategy());
    }

    @Deprecated
    public DynamoDbMapperConfig(DynamoDbMapperConfig defaults, DynamoDbMapperConfig overrides) {
        this(DynamoDbMapperConfig.builder().merge(defaults).merge(overrides));
    }

    public static Builder builder() {
        return new Builder(false);
    }

    final DynamoDbMapperConfig merge(DynamoDbMapperConfig overrides) {
        return overrides == null || this.equals(overrides) ? this : DynamoDbMapperConfig.builder().merge(this).merge(overrides).build();
    }

    public BatchLoadRetryStrategy batchLoadRetryStrategy() {
        return this.batchLoadRetryStrategy;
    }

    public SaveBehavior saveBehavior() {
        return this.saveBehavior;
    }

    public ConsistentReads getConsistentReads() {
        return this.consistentReads;
    }

    public TableNameOverride getTableNameOverride() {
        return this.tableNameOverride;
    }

    public TableNameResolver getTableNameResolver() {
        return this.tableNameResolver;
    }

    public ObjectTableNameResolver getObjectTableNameResolver() {
        return this.objectTableNameResolver;
    }

    public PaginationLoadingStrategy getPaginationLoadingStrategy() {
        return this.paginationLoadingStrategy;
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public ConversionSchema getConversionSchema() {
        return this.conversionschema;
    }

    public BatchWriteRetryStrategy batchWriteRetryStrategy() {
        return this.batchWriteRetryStrategy;
    }

    public final DynamoDbTypeConverterFactory getTypeConverterFactory() {
        return this.typeConverterFactory;
    }

    public static class DefaultBatchWriteRetryStrategy
    implements BatchWriteRetryStrategy {
        public static final DefaultBatchWriteRetryStrategy INSTANCE = new DefaultBatchWriteRetryStrategy();
        private static final long MAX_BACKOFF_IN_MILLISECONDS = 3000L;
        private static final int DEFAULT_MAX_RETRY = -1;
        private final int maxRetry;
        private final DynamoDbMapperConfig config = DynamoDbMapperConfig.builder().withBatchWriteRetryStrategy(this).build();

        public DefaultBatchWriteRetryStrategy() {
            this(-1);
        }

        public DefaultBatchWriteRetryStrategy(int maxRetry) {
            this.maxRetry = maxRetry;
        }

        @Override
        public int maxRetryOnUnprocessedItems(Map<String, List<WriteRequest>> batchWriteItemInput) {
            return this.maxRetry;
        }

        @Override
        public long getDelayBeforeRetryUnprocessedItems(Map<String, List<WriteRequest>> unprocessedItems, int retriesAttempted) {
            if (retriesAttempted < 0) {
                return 0L;
            }
            SecureRandom random = new SecureRandom();
            long scaleFactor = 1000L + (long)random.nextInt(200);
            long delay = (long)(Math.pow(2.0, retriesAttempted) * (double)scaleFactor);
            return Math.min(delay, 3000L);
        }

        public final DynamoDbMapperConfig config() {
            return this.config;
        }
    }

    public static class DefaultBatchLoadRetryStrategy
    implements BatchLoadRetryStrategy {
        public static final DefaultBatchLoadRetryStrategy INSTANCE = new DefaultBatchLoadRetryStrategy();
        private static final int MAX_RETRIES = 5;
        private static final long MAX_BACKOFF_IN_MILLISECONDS = 3000L;
        private final DynamoDbMapperConfig config = DynamoDbMapperConfig.builder().withBatchLoadRetryStrategy(this).build();

        @Override
        public long getDelayBeforeNextRetry(BatchLoadContext batchLoadContext) {
            Map<String, KeysAndAttributes> requestedKeys = batchLoadContext.batchGetItemRequest().requestItems();
            Map<String, KeysAndAttributes> unprocessedKeys = batchLoadContext.batchGetItemResponse().unprocessedKeys();
            long delay = 0L;
            if (unprocessedKeys != null && requestedKeys != null && unprocessedKeys.size() == requestedKeys.size()) {
                SecureRandom random = new SecureRandom();
                long scaleFactor = 500L + (long)random.nextInt(100);
                int retriesAttempted = batchLoadContext.getRetriesAttempted();
                delay = (long)(Math.pow(2.0, retriesAttempted) * (double)scaleFactor);
                delay = Math.min(delay, 3000L);
            }
            return delay;
        }

        @Override
        public boolean shouldRetry(BatchLoadContext batchLoadContext) {
            Map<String, KeysAndAttributes> unprocessedKeys = batchLoadContext.batchGetItemResponse().unprocessedKeys();
            return unprocessedKeys != null && unprocessedKeys.size() > 0 && batchLoadContext.getRetriesAttempted() < 5;
        }

        public final DynamoDbMapperConfig config() {
            return this.config;
        }
    }

    public static class NoRetryBatchLoadRetryStrategy
    implements BatchLoadRetryStrategy {
        public static final NoRetryBatchLoadRetryStrategy INSTANCE = new NoRetryBatchLoadRetryStrategy();
        private final DynamoDbMapperConfig config = DynamoDbMapperConfig.builder().withBatchLoadRetryStrategy(this).build();

        @Override
        public boolean shouldRetry(BatchLoadContext batchLoadContext) {
            return false;
        }

        @Override
        public long getDelayBeforeNextRetry(BatchLoadContext batchLoadContext) {
            return -1L;
        }

        public final DynamoDbMapperConfig config() {
            return this.config;
        }
    }

    public static class DefaultTableNameResolver
    implements TableNameResolver {
        public static final DefaultTableNameResolver INSTANCE = new DefaultTableNameResolver();
        private final DynamoDbMapperConfig config = DynamoDbMapperConfig.builder().withTableNameResolver(this).build();

        @Override
        public String getTableName(Class<?> clazz, DynamoDbMapperConfig config) {
            String tableName;
            TableNameOverride override = config.getTableNameOverride();
            if (override != null && (tableName = override.getTableName()) != null) {
                return tableName;
            }
            StandardBeanProperties.Beans<?> beans = StandardBeanProperties.of(clazz);
            if (beans.properties().tableName() == null) {
                throw new DynamoDbMappingException(clazz + " not annotated with @DynamoDBTable");
            }
            String prefix = override == null ? null : override.getTableNamePrefix();
            return prefix == null ? beans.properties().tableName() : prefix + beans.properties().tableName();
        }

        public final DynamoDbMapperConfig config() {
            return this.config;
        }
    }

    public static final class TableNameOverride {
        private final String tableNameOverride;
        private final String tableNamePrefix;
        private final DynamoDbMapperConfig config = DynamoDbMapperConfig.builder().withTableNameOverride(this).build();

        private TableNameOverride(String tableNameOverride, String tableNamePrefix) {
            this.tableNameOverride = tableNameOverride;
            this.tableNamePrefix = tableNamePrefix;
        }

        public TableNameOverride(String tableNameOverride) {
            this(tableNameOverride, null);
        }

        public static TableNameOverride withTableNamePrefix(String tableNamePrefix) {
            return new TableNameOverride(null, tableNamePrefix);
        }

        public static TableNameOverride withTableNameReplacement(String tableNameReplacement) {
            return new TableNameOverride(tableNameReplacement, null);
        }

        public String getTableName() {
            return this.tableNameOverride;
        }

        public String getTableNamePrefix() {
            return this.tableNamePrefix;
        }

        public DynamoDbMapperConfig config() {
            return this.config;
        }
    }

    public static class Builder {
        private SaveBehavior saveBehavior;
        private ConsistentReads consistentReads;
        private TableNameOverride tableNameOverride;
        private TableNameResolver tableNameResolver;
        private ObjectTableNameResolver objectTableNameResolver;
        private PaginationLoadingStrategy paginationLoadingStrategy;
        private RequestMetricCollector requestMetricCollector;
        private ConversionSchema conversionschema;
        private BatchWriteRetryStrategy batchWriteRetryStrategy;
        private BatchLoadRetryStrategy batchLoadRetryStrategy;
        private DynamoDbTypeConverterFactory typeConverterFactory;

        public Builder() {
            this(true);
        }

        private Builder(boolean defaults) {
            if (defaults) {
                this.saveBehavior = DEFAULT.saveBehavior();
                this.consistentReads = DEFAULT.getConsistentReads();
                this.paginationLoadingStrategy = DEFAULT.getPaginationLoadingStrategy();
                this.conversionschema = DEFAULT.getConversionSchema();
                this.batchWriteRetryStrategy = DEFAULT.batchWriteRetryStrategy();
                this.batchLoadRetryStrategy = DEFAULT.batchLoadRetryStrategy();
            }
        }

        private Builder merge(DynamoDbMapperConfig o) {
            if (o == null) {
                return this;
            }
            if (o.saveBehavior != null) {
                this.saveBehavior = o.saveBehavior;
            }
            if (o.consistentReads != null) {
                this.consistentReads = o.consistentReads;
            }
            if (o.tableNameOverride != null) {
                this.tableNameOverride = o.tableNameOverride;
            }
            if (o.tableNameResolver != null) {
                this.tableNameResolver = o.tableNameResolver;
            }
            if (o.objectTableNameResolver != null) {
                this.objectTableNameResolver = o.objectTableNameResolver;
            }
            if (o.paginationLoadingStrategy != null) {
                this.paginationLoadingStrategy = o.paginationLoadingStrategy;
            }
            if (o.requestMetricCollector != null) {
                this.requestMetricCollector = o.requestMetricCollector;
            }
            if (o.conversionschema != null) {
                this.conversionschema = o.conversionschema;
            }
            if (o.batchWriteRetryStrategy != null) {
                this.batchWriteRetryStrategy = o.batchWriteRetryStrategy;
            }
            if (o.batchLoadRetryStrategy != null) {
                this.batchLoadRetryStrategy = o.batchLoadRetryStrategy;
            }
            if (o.typeConverterFactory != null) {
                this.typeConverterFactory = o.typeConverterFactory;
            }
            return this;
        }

        public SaveBehavior saveBehavior() {
            return this.saveBehavior;
        }

        public void setSaveBehavior(SaveBehavior value) {
            this.saveBehavior = value;
        }

        public Builder withSaveBehavior(SaveBehavior value) {
            this.setSaveBehavior(value);
            return this;
        }

        public ConsistentReads getConsistentReads() {
            return this.consistentReads;
        }

        public void setConsistentReads(ConsistentReads value) {
            this.consistentReads = value;
        }

        public Builder withConsistentReads(ConsistentReads value) {
            this.setConsistentReads(value);
            return this;
        }

        public TableNameOverride getTableNameOverride() {
            return this.tableNameOverride;
        }

        public void setTableNameOverride(TableNameOverride value) {
            this.tableNameOverride = value;
        }

        public Builder withTableNameOverride(TableNameOverride value) {
            this.setTableNameOverride(value);
            return this;
        }

        public TableNameResolver getTableNameResolver() {
            return this.tableNameResolver;
        }

        public void setTableNameResolver(TableNameResolver value) {
            this.tableNameResolver = value;
        }

        public Builder withTableNameResolver(TableNameResolver value) {
            this.setTableNameResolver(value);
            return this;
        }

        public ObjectTableNameResolver getObjectTableNameResolver() {
            return this.objectTableNameResolver;
        }

        public void setObjectTableNameResolver(ObjectTableNameResolver value) {
            this.objectTableNameResolver = value;
        }

        public Builder withObjectTableNameResolver(ObjectTableNameResolver value) {
            this.setObjectTableNameResolver(value);
            return this;
        }

        public PaginationLoadingStrategy getPaginationLoadingStrategy() {
            return this.paginationLoadingStrategy;
        }

        public void setPaginationLoadingStrategy(PaginationLoadingStrategy value) {
            this.paginationLoadingStrategy = value;
        }

        public Builder withPaginationLoadingStrategy(PaginationLoadingStrategy value) {
            this.setPaginationLoadingStrategy(value);
            return this;
        }

        public RequestMetricCollector getRequestMetricCollector() {
            return this.requestMetricCollector;
        }

        public void setRequestMetricCollector(RequestMetricCollector value) {
            this.requestMetricCollector = value;
        }

        public Builder withRequestMetricCollector(RequestMetricCollector value) {
            this.setRequestMetricCollector(value);
            return this;
        }

        public ConversionSchema getConversionSchema() {
            return this.conversionschema;
        }

        public void setConversionSchema(ConversionSchema value) {
            this.conversionschema = value;
        }

        public Builder withConversionSchema(ConversionSchema value) {
            this.setConversionSchema(value);
            return this;
        }

        public BatchWriteRetryStrategy batchWriteRetryStrategy() {
            return this.batchWriteRetryStrategy;
        }

        public void setBatchWriteRetryStrategy(BatchWriteRetryStrategy value) {
            this.batchWriteRetryStrategy = value;
        }

        public Builder withBatchWriteRetryStrategy(BatchWriteRetryStrategy value) {
            this.setBatchWriteRetryStrategy(value);
            return this;
        }

        public BatchLoadRetryStrategy batchLoadRetryStrategy() {
            return this.batchLoadRetryStrategy;
        }

        public void setBatchLoadRetryStrategy(BatchLoadRetryStrategy value) {
            this.batchLoadRetryStrategy = value;
        }

        public Builder withBatchLoadRetryStrategy(BatchLoadRetryStrategy value) {
            if (value == null) {
                value = NoRetryBatchLoadRetryStrategy.INSTANCE;
            }
            this.setBatchLoadRetryStrategy(value);
            return this;
        }

        public final DynamoDbTypeConverterFactory getTypeConverterFactory() {
            return this.typeConverterFactory;
        }

        public final void setTypeConverterFactory(DynamoDbTypeConverterFactory value) {
            this.typeConverterFactory = value;
        }

        public final Builder withTypeConverterFactory(DynamoDbTypeConverterFactory value) {
            this.setTypeConverterFactory(value);
            return this;
        }

        public DynamoDbMapperConfig build() {
            return new DynamoDbMapperConfig(this);
        }
    }

    public static interface BatchLoadRetryStrategy {
        public boolean shouldRetry(BatchLoadContext var1);

        public long getDelayBeforeNextRetry(BatchLoadContext var1);
    }

    public static interface BatchWriteRetryStrategy {
        public int maxRetryOnUnprocessedItems(Map<String, List<WriteRequest>> var1);

        public long getDelayBeforeRetryUnprocessedItems(Map<String, List<WriteRequest>> var1, int var2);
    }

    public static interface ObjectTableNameResolver {
        public String getTableName(Object var1, DynamoDbMapperConfig var2);
    }

    public static interface TableNameResolver {
        public String getTableName(Class<?> var1, DynamoDbMapperConfig var2);
    }

    public static enum PaginationLoadingStrategy {
        LAZY_LOADING,
        ITERATION_ONLY,
        EAGER_LOADING;

        private final DynamoDbMapperConfig config = DynamoDbMapperConfig.builder().withPaginationLoadingStrategy(this).build();

        public final DynamoDbMapperConfig config() {
            return this.config;
        }
    }

    public static enum ConsistentReads {
        CONSISTENT,
        EVENTUAL;

        private final DynamoDbMapperConfig config = DynamoDbMapperConfig.builder().withConsistentReads(this).build();

        public final DynamoDbMapperConfig config() {
            return this.config;
        }
    }

    public static enum SaveBehavior {
        UPDATE,
        UPDATE_SKIP_NULL_ATTRIBUTES,
        CLOBBER,
        APPEND_SET;

        private final DynamoDbMapperConfig config = DynamoDbMapperConfig.builder().withSaveBehavior(this).build();

        public final DynamoDbMapperConfig config() {
            return this.config;
        }
    }
}

