/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperFieldModel;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMappingException;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverter;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardAnnotationMaps;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardBeanProperties;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardTypeConverters;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;

@SdkInternalApi
final class ConvertibleType<T> {
    private final DynamoDbTypeConverter<?, T> typeConverter;
    private final DynamoDbMapperFieldModel.DynamoDbAttributeType attributeType;
    private final ConvertibleType<T>[] params;
    private final Class<T> targetType;
    @Deprecated
    private final Method getter;
    @Deprecated
    private final Method setter;

    private ConvertibleType(Type genericType, StandardAnnotationMaps.TypedMap<T> annotations, Method getter) {
        this.typeConverter = annotations.typeConverter();
        this.attributeType = annotations.attributeType();
        if (this.typeConverter != null) {
            ConvertibleType<T> target = ConvertibleType.of(this.typeConverter);
            this.targetType = target.targetType;
            this.params = target.params;
        } else if (genericType instanceof ParameterizedType) {
            Type[] paramTypes = ((ParameterizedType)genericType).getActualTypeArguments();
            this.targetType = annotations.targetType();
            this.params = new ConvertibleType[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                this.params[i] = ConvertibleType.of(paramTypes[i]);
            }
        } else {
            this.targetType = annotations.targetType();
            this.params = new ConvertibleType[0];
        }
        this.setter = getter == null ? null : StandardBeanProperties.MethodReflect.setterOf(getter);
        this.getter = getter;
    }

    static <T> ConvertibleType<T> of(Method getter, StandardAnnotationMaps.TypedMap<T> annotations) {
        return new ConvertibleType<T>(getter.getGenericReturnType(), annotations, getter);
    }

    private static <T> ConvertibleType<T> of(DynamoDbTypeConverter<?, T> converter) {
        Class<?> clazz = converter.getClass();
        if (!clazz.isInterface()) {
            for (Class<?> c = clazz; Object.class != c; c = c.getSuperclass()) {
                for (Type genericType : c.getGenericInterfaces()) {
                    ConvertibleType<T> type = ConvertibleType.of(genericType);
                    if (!type.is(DynamoDbTypeConverter.class) || type.params.length != 2 || type.param(0).targetType() == Object.class) continue;
                    return type.param(0);
                }
            }
            ConvertibleType<T> type = ConvertibleType.of(clazz.getGenericSuperclass());
            if (type.is(DynamoDbTypeConverter.class) && type.params.length > 0 && type.param(0).targetType() != Object.class) {
                return type.param(0);
            }
        }
        throw new DynamoDbMappingException("could not resolve type of " + clazz);
    }

    private static <T> ConvertibleType<T> of(Type genericType) {
        Class targetType = genericType instanceof Class ? (Class<byte[]>)((Object)genericType) : (genericType instanceof ParameterizedType ? (Class)((ParameterizedType)genericType).getRawType() : (genericType.toString().equals("byte[]") ? byte[].class : Object.class));
        StandardAnnotationMaps.TableMap annotations = StandardAnnotationMaps.of(targetType);
        return new ConvertibleType(genericType, annotations, null);
    }

    <S> DynamoDbTypeConverter<S, T> typeConverter() {
        return this.typeConverter;
    }

    DynamoDbMapperFieldModel.DynamoDbAttributeType attributeType() {
        return this.attributeType;
    }

    @Deprecated
    Method getter() {
        return this.getter;
    }

    @Deprecated
    Method setter() {
        return this.setter;
    }

    <U> ConvertibleType<U> param(int index) {
        return this.params.length > index ? this.params[index] : null;
    }

    boolean is(ScalarAttributeType scalarAttributeType, StandardTypeConverters.Vector vector) {
        return this.param(0) != null && this.param(0).is(scalarAttributeType) && this.is(vector);
    }

    boolean is(ScalarAttributeType scalarAttributeType) {
        return StandardTypeConverters.Scalar.of(this.targetType()).is(scalarAttributeType);
    }

    boolean is(StandardTypeConverters.Scalar scalar) {
        return scalar.is(this.targetType());
    }

    boolean is(StandardTypeConverters.Vector vector) {
        return vector.is(this.targetType());
    }

    boolean is(Class<?> type) {
        return type.isAssignableFrom(this.targetType());
    }

    Class<T> targetType() {
        return this.targetType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.targetType().getSimpleName());
        if (this.params.length > 0) {
            builder.append("<");
            for (int i = 0; i < this.params.length; ++i) {
                builder.append(i == 0 ? "" : ",").append(this.params[i]);
            }
            builder.append(">");
        }
        return builder.toString();
    }
}

