/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.ReplicaUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReplicaUpdateMarshaller {
    private static final MarshallingInfo<StructuredPojo> CREATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Create").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DELETE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Delete").isBinary(false).build();
    private static final ReplicaUpdateMarshaller INSTANCE = new ReplicaUpdateMarshaller();

    private ReplicaUpdateMarshaller() {
    }

    public static ReplicaUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReplicaUpdate replicaUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)replicaUpdate, (String)"replicaUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)replicaUpdate.create(), CREATE_BINDING);
            protocolMarshaller.marshall((Object)replicaUpdate.delete(), DELETE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

