/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReplicaSettingsUpdateMarshaller {
    private static final MarshallingInfo<String> REGIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegionName").isBinary(false).build();
    private static final MarshallingInfo<Long> REPLICAPROVISIONEDREADCAPACITYUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicaProvisionedReadCapacityUnits").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> REPLICAPROVISIONEDREADCAPACITYAUTOSCALINGSETTINGSUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicaProvisionedReadCapacityAutoScalingSettingsUpdate").isBinary(false).build();
    private static final MarshallingInfo<List> REPLICAGLOBALSECONDARYINDEXSETTINGSUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicaGlobalSecondaryIndexSettingsUpdate").isBinary(false).build();
    private static final ReplicaSettingsUpdateMarshaller INSTANCE = new ReplicaSettingsUpdateMarshaller();

    private ReplicaSettingsUpdateMarshaller() {
    }

    public static ReplicaSettingsUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReplicaSettingsUpdate replicaSettingsUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)replicaSettingsUpdate, (String)"replicaSettingsUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)replicaSettingsUpdate.regionName(), REGIONNAME_BINDING);
            protocolMarshaller.marshall((Object)replicaSettingsUpdate.replicaProvisionedReadCapacityUnits(), REPLICAPROVISIONEDREADCAPACITYUNITS_BINDING);
            protocolMarshaller.marshall((Object)replicaSettingsUpdate.replicaProvisionedReadCapacityAutoScalingSettingsUpdate(), REPLICAPROVISIONEDREADCAPACITYAUTOSCALINGSETTINGSUPDATE_BINDING);
            protocolMarshaller.marshall(replicaSettingsUpdate.replicaGlobalSecondaryIndexSettingsUpdate(), REPLICAGLOBALSECONDARYINDEXSETTINGSUPDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

