/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.transform.CapacityUnmarshaller;

public class ConsumedCapacityUnmarshaller
implements Unmarshaller<ConsumedCapacity, JsonUnmarshallerContext> {
    private static final ConsumedCapacityUnmarshaller INSTANCE = new ConsumedCapacityUnmarshaller();

    public ConsumedCapacity unmarshall(JsonUnmarshallerContext context) throws Exception {
        ConsumedCapacity.Builder consumedCapacityBuilder = ConsumedCapacity.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("TableName", targetDepth)) {
                    context.nextToken();
                    consumedCapacityBuilder.tableName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CapacityUnits", targetDepth)) {
                    context.nextToken();
                    consumedCapacityBuilder.capacityUnits((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("Table", targetDepth)) {
                    context.nextToken();
                    consumedCapacityBuilder.table(CapacityUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LocalSecondaryIndexes", targetDepth)) {
                    context.nextToken();
                    consumedCapacityBuilder.localSecondaryIndexes(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)CapacityUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("GlobalSecondaryIndexes", targetDepth)) {
                    context.nextToken();
                    consumedCapacityBuilder.globalSecondaryIndexes(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)CapacityUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ConsumedCapacity)consumedCapacityBuilder.build();
    }

    public static ConsumedCapacityUnmarshaller getInstance() {
        return INSTANCE;
    }
}

