/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.BackupSummary;

public class BackupSummaryUnmarshaller
implements Unmarshaller<BackupSummary, JsonUnmarshallerContext> {
    private static final BackupSummaryUnmarshaller INSTANCE = new BackupSummaryUnmarshaller();

    public BackupSummary unmarshall(JsonUnmarshallerContext context) throws Exception {
        BackupSummary.Builder backupSummaryBuilder = BackupSummary.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("TableName", targetDepth)) {
                    context.nextToken();
                    backupSummaryBuilder.tableName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TableId", targetDepth)) {
                    context.nextToken();
                    backupSummaryBuilder.tableId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TableArn", targetDepth)) {
                    context.nextToken();
                    backupSummaryBuilder.tableArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BackupArn", targetDepth)) {
                    context.nextToken();
                    backupSummaryBuilder.backupArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BackupName", targetDepth)) {
                    context.nextToken();
                    backupSummaryBuilder.backupName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BackupCreationDateTime", targetDepth)) {
                    context.nextToken();
                    backupSummaryBuilder.backupCreationDateTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("BackupExpiryDateTime", targetDepth)) {
                    context.nextToken();
                    backupSummaryBuilder.backupExpiryDateTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("BackupStatus", targetDepth)) {
                    context.nextToken();
                    backupSummaryBuilder.backupStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BackupType", targetDepth)) {
                    context.nextToken();
                    backupSummaryBuilder.backupType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BackupSizeBytes", targetDepth)) {
                    context.nextToken();
                    backupSummaryBuilder.backupSizeBytes((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (BackupSummary)backupSummaryBuilder.build();
    }

    public static BackupSummaryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

