/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.BackupSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BackupSummaryMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<String> TABLEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableId").isBinary(false).build();
    private static final MarshallingInfo<String> TABLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableArn").isBinary(false).build();
    private static final MarshallingInfo<String> BACKUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupArn").isBinary(false).build();
    private static final MarshallingInfo<String> BACKUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupName").isBinary(false).build();
    private static final MarshallingInfo<Instant> BACKUPCREATIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupCreationDateTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> BACKUPEXPIRYDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupExpiryDateTime").isBinary(false).build();
    private static final MarshallingInfo<String> BACKUPSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupStatus").isBinary(false).build();
    private static final MarshallingInfo<String> BACKUPTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupType").isBinary(false).build();
    private static final MarshallingInfo<Long> BACKUPSIZEBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupSizeBytes").isBinary(false).build();
    private static final BackupSummaryMarshaller INSTANCE = new BackupSummaryMarshaller();

    private BackupSummaryMarshaller() {
    }

    public static BackupSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BackupSummary backupSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)backupSummary, (String)"backupSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)backupSummary.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)backupSummary.tableId(), TABLEID_BINDING);
            protocolMarshaller.marshall((Object)backupSummary.tableArn(), TABLEARN_BINDING);
            protocolMarshaller.marshall((Object)backupSummary.backupArn(), BACKUPARN_BINDING);
            protocolMarshaller.marshall((Object)backupSummary.backupName(), BACKUPNAME_BINDING);
            protocolMarshaller.marshall((Object)backupSummary.backupCreationDateTime(), BACKUPCREATIONDATETIME_BINDING);
            protocolMarshaller.marshall((Object)backupSummary.backupExpiryDateTime(), BACKUPEXPIRYDATETIME_BINDING);
            protocolMarshaller.marshall((Object)backupSummary.backupStatusAsString(), BACKUPSTATUS_BINDING);
            protocolMarshaller.marshall((Object)backupSummary.backupTypeAsString(), BACKUPTYPE_BINDING);
            protocolMarshaller.marshall((Object)backupSummary.backupSizeBytes(), BACKUPSIZEBYTES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

