/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.TableNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTablesResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, ListTablesResponse> {
    private final List<String> tableNames;
    private final String lastEvaluatedTableName;

    private ListTablesResponse(BuilderImpl builder) {
        super(builder);
        this.tableNames = builder.tableNames;
        this.lastEvaluatedTableName = builder.lastEvaluatedTableName;
    }

    public List<String> tableNames() {
        return this.tableNames;
    }

    public String lastEvaluatedTableName() {
        return this.lastEvaluatedTableName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluatedTableName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTablesResponse)) {
            return false;
        }
        ListTablesResponse other = (ListTablesResponse)((Object)obj);
        return Objects.equals(this.tableNames(), other.tableNames()) && Objects.equals(this.lastEvaluatedTableName(), other.lastEvaluatedTableName());
    }

    public String toString() {
        return ToString.builder((String)"ListTablesResponse").add("TableNames", this.tableNames()).add("LastEvaluatedTableName", (Object)this.lastEvaluatedTableName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableNames": {
                return Optional.ofNullable(clazz.cast(this.tableNames()));
            }
            case "LastEvaluatedTableName": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluatedTableName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private List<String> tableNames = DefaultSdkAutoConstructList.getInstance();
        private String lastEvaluatedTableName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTablesResponse model) {
            super(model);
            this.tableNames(model.tableNames);
            this.lastEvaluatedTableName(model.lastEvaluatedTableName);
        }

        public final Collection<String> getTableNames() {
            return this.tableNames;
        }

        @Override
        public final Builder tableNames(Collection<String> tableNames) {
            this.tableNames = TableNameListCopier.copy(tableNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableNames(String ... tableNames) {
            this.tableNames(Arrays.asList(tableNames));
            return this;
        }

        public final void setTableNames(Collection<String> tableNames) {
            this.tableNames = TableNameListCopier.copy(tableNames);
        }

        public final String getLastEvaluatedTableName() {
            return this.lastEvaluatedTableName;
        }

        @Override
        public final Builder lastEvaluatedTableName(String lastEvaluatedTableName) {
            this.lastEvaluatedTableName = lastEvaluatedTableName;
            return this;
        }

        public final void setLastEvaluatedTableName(String lastEvaluatedTableName) {
            this.lastEvaluatedTableName = lastEvaluatedTableName;
        }

        @Override
        public ListTablesResponse build() {
            return new ListTablesResponse(this);
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    CopyableBuilder<Builder, ListTablesResponse> {
        public Builder tableNames(Collection<String> var1);

        public Builder tableNames(String ... var1);

        public Builder lastEvaluatedTableName(String var1);
    }
}

