/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.GlobalTable;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGlobalTablesResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, ListGlobalTablesResponse> {
    private final List<GlobalTable> globalTables;
    private final String lastEvaluatedGlobalTableName;

    private ListGlobalTablesResponse(BuilderImpl builder) {
        super(builder);
        this.globalTables = builder.globalTables;
        this.lastEvaluatedGlobalTableName = builder.lastEvaluatedGlobalTableName;
    }

    public List<GlobalTable> globalTables() {
        return this.globalTables;
    }

    public String lastEvaluatedGlobalTableName() {
        return this.lastEvaluatedGlobalTableName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTables());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluatedGlobalTableName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGlobalTablesResponse)) {
            return false;
        }
        ListGlobalTablesResponse other = (ListGlobalTablesResponse)((Object)obj);
        return Objects.equals(this.globalTables(), other.globalTables()) && Objects.equals(this.lastEvaluatedGlobalTableName(), other.lastEvaluatedGlobalTableName());
    }

    public String toString() {
        return ToString.builder((String)"ListGlobalTablesResponse").add("GlobalTables", this.globalTables()).add("LastEvaluatedGlobalTableName", (Object)this.lastEvaluatedGlobalTableName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalTables": {
                return Optional.ofNullable(clazz.cast(this.globalTables()));
            }
            case "LastEvaluatedGlobalTableName": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluatedGlobalTableName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private List<GlobalTable> globalTables = DefaultSdkAutoConstructList.getInstance();
        private String lastEvaluatedGlobalTableName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGlobalTablesResponse model) {
            super(model);
            this.globalTables(model.globalTables);
            this.lastEvaluatedGlobalTableName(model.lastEvaluatedGlobalTableName);
        }

        public final Collection<GlobalTable.Builder> getGlobalTables() {
            return this.globalTables != null ? (Collection)this.globalTables.stream().map(GlobalTable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalTables(Collection<GlobalTable> globalTables) {
            this.globalTables = GlobalTableListCopier.copy(globalTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalTables(GlobalTable ... globalTables) {
            this.globalTables(Arrays.asList(globalTables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalTables(Consumer<GlobalTable.Builder> ... globalTables) {
            this.globalTables(Stream.of(globalTables).map(c -> (GlobalTable)((GlobalTable.Builder)GlobalTable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalTables(Collection<GlobalTable.BuilderImpl> globalTables) {
            this.globalTables = GlobalTableListCopier.copyFromBuilder(globalTables);
        }

        public final String getLastEvaluatedGlobalTableName() {
            return this.lastEvaluatedGlobalTableName;
        }

        @Override
        public final Builder lastEvaluatedGlobalTableName(String lastEvaluatedGlobalTableName) {
            this.lastEvaluatedGlobalTableName = lastEvaluatedGlobalTableName;
            return this;
        }

        public final void setLastEvaluatedGlobalTableName(String lastEvaluatedGlobalTableName) {
            this.lastEvaluatedGlobalTableName = lastEvaluatedGlobalTableName;
        }

        @Override
        public ListGlobalTablesResponse build() {
            return new ListGlobalTablesResponse(this);
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    CopyableBuilder<Builder, ListGlobalTablesResponse> {
        public Builder globalTables(Collection<GlobalTable> var1);

        public Builder globalTables(GlobalTable ... var1);

        public Builder globalTables(Consumer<GlobalTable.Builder> ... var1);

        public Builder lastEvaluatedGlobalTableName(String var1);
    }
}

