/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbStreamsRequest;
import software.amazon.awssdk.services.dynamodb.model.ShardIteratorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetShardIteratorRequest
extends DynamoDbStreamsRequest
implements ToCopyableBuilder<Builder, GetShardIteratorRequest> {
    private final String streamArn;
    private final String shardId;
    private final String shardIteratorType;
    private final String sequenceNumber;

    private GetShardIteratorRequest(BuilderImpl builder) {
        super(builder);
        this.streamArn = builder.streamArn;
        this.shardId = builder.shardId;
        this.shardIteratorType = builder.shardIteratorType;
        this.sequenceNumber = builder.sequenceNumber;
    }

    public String streamArn() {
        return this.streamArn;
    }

    public String shardId() {
        return this.shardId;
    }

    public ShardIteratorType shardIteratorType() {
        return ShardIteratorType.fromValue(this.shardIteratorType);
    }

    public String shardIteratorTypeAsString() {
        return this.shardIteratorType;
    }

    public String sequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardIteratorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetShardIteratorRequest)) {
            return false;
        }
        GetShardIteratorRequest other = (GetShardIteratorRequest)((Object)obj);
        return Objects.equals(this.streamArn(), other.streamArn()) && Objects.equals(this.shardId(), other.shardId()) && Objects.equals(this.shardIteratorTypeAsString(), other.shardIteratorTypeAsString()) && Objects.equals(this.sequenceNumber(), other.sequenceNumber());
    }

    public String toString() {
        return ToString.builder((String)"GetShardIteratorRequest").add("StreamArn", (Object)this.streamArn()).add("ShardId", (Object)this.shardId()).add("ShardIteratorType", (Object)this.shardIteratorTypeAsString()).add("SequenceNumber", (Object)this.sequenceNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamArn": {
                return Optional.ofNullable(clazz.cast(this.streamArn()));
            }
            case "ShardId": {
                return Optional.ofNullable(clazz.cast(this.shardId()));
            }
            case "ShardIteratorType": {
                return Optional.ofNullable(clazz.cast(this.shardIteratorTypeAsString()));
            }
            case "SequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.sequenceNumber()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDbStreamsRequest.BuilderImpl
    implements Builder {
        private String streamArn;
        private String shardId;
        private String shardIteratorType;
        private String sequenceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(GetShardIteratorRequest model) {
            super(model);
            this.streamArn(model.streamArn);
            this.shardId(model.shardId);
            this.shardIteratorType(model.shardIteratorType);
            this.sequenceNumber(model.sequenceNumber);
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final String getShardId() {
            return this.shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final String getShardIteratorType() {
            return this.shardIteratorType;
        }

        @Override
        public final Builder shardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
            return this;
        }

        @Override
        public final Builder shardIteratorType(ShardIteratorType shardIteratorType) {
            this.shardIteratorType(shardIteratorType.toString());
            return this;
        }

        public final void setShardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
        }

        public final String getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetShardIteratorRequest build() {
            return new GetShardIteratorRequest(this);
        }
    }

    public static interface Builder
    extends DynamoDbStreamsRequest.Builder,
    CopyableBuilder<Builder, GetShardIteratorRequest> {
        public Builder streamArn(String var1);

        public Builder shardId(String var1);

        public Builder shardIteratorType(String var1);

        public Builder shardIteratorType(ShardIteratorType var1);

        public Builder sequenceNumber(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

