/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyUpdate;
import software.amazon.awssdk.services.dynamodb.transform.AutoScalingSettingsUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingSettingsUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, AutoScalingSettingsUpdate> {
    private final Long minimumUnits;
    private final Long maximumUnits;
    private final Boolean autoScalingDisabled;
    private final String autoScalingRoleArn;
    private final AutoScalingPolicyUpdate scalingPolicyUpdate;

    private AutoScalingSettingsUpdate(BuilderImpl builder) {
        this.minimumUnits = builder.minimumUnits;
        this.maximumUnits = builder.maximumUnits;
        this.autoScalingDisabled = builder.autoScalingDisabled;
        this.autoScalingRoleArn = builder.autoScalingRoleArn;
        this.scalingPolicyUpdate = builder.scalingPolicyUpdate;
    }

    public Long minimumUnits() {
        return this.minimumUnits;
    }

    public Long maximumUnits() {
        return this.maximumUnits;
    }

    public Boolean autoScalingDisabled() {
        return this.autoScalingDisabled;
    }

    public String autoScalingRoleArn() {
        return this.autoScalingRoleArn;
    }

    public AutoScalingPolicyUpdate scalingPolicyUpdate() {
        return this.scalingPolicyUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPolicyUpdate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingSettingsUpdate)) {
            return false;
        }
        AutoScalingSettingsUpdate other = (AutoScalingSettingsUpdate)obj;
        return Objects.equals(this.minimumUnits(), other.minimumUnits()) && Objects.equals(this.maximumUnits(), other.maximumUnits()) && Objects.equals(this.autoScalingDisabled(), other.autoScalingDisabled()) && Objects.equals(this.autoScalingRoleArn(), other.autoScalingRoleArn()) && Objects.equals(this.scalingPolicyUpdate(), other.scalingPolicyUpdate());
    }

    public String toString() {
        return ToString.builder((String)"AutoScalingSettingsUpdate").add("MinimumUnits", (Object)this.minimumUnits()).add("MaximumUnits", (Object)this.maximumUnits()).add("AutoScalingDisabled", (Object)this.autoScalingDisabled()).add("AutoScalingRoleArn", (Object)this.autoScalingRoleArn()).add("ScalingPolicyUpdate", (Object)this.scalingPolicyUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinimumUnits": {
                return Optional.ofNullable(clazz.cast(this.minimumUnits()));
            }
            case "MaximumUnits": {
                return Optional.ofNullable(clazz.cast(this.maximumUnits()));
            }
            case "AutoScalingDisabled": {
                return Optional.ofNullable(clazz.cast(this.autoScalingDisabled()));
            }
            case "AutoScalingRoleArn": {
                return Optional.ofNullable(clazz.cast(this.autoScalingRoleArn()));
            }
            case "ScalingPolicyUpdate": {
                return Optional.ofNullable(clazz.cast(this.scalingPolicyUpdate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoScalingSettingsUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long minimumUnits;
        private Long maximumUnits;
        private Boolean autoScalingDisabled;
        private String autoScalingRoleArn;
        private AutoScalingPolicyUpdate scalingPolicyUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingSettingsUpdate model) {
            this.minimumUnits(model.minimumUnits);
            this.maximumUnits(model.maximumUnits);
            this.autoScalingDisabled(model.autoScalingDisabled);
            this.autoScalingRoleArn(model.autoScalingRoleArn);
            this.scalingPolicyUpdate(model.scalingPolicyUpdate);
        }

        public final Long getMinimumUnits() {
            return this.minimumUnits;
        }

        @Override
        public final Builder minimumUnits(Long minimumUnits) {
            this.minimumUnits = minimumUnits;
            return this;
        }

        public final void setMinimumUnits(Long minimumUnits) {
            this.minimumUnits = minimumUnits;
        }

        public final Long getMaximumUnits() {
            return this.maximumUnits;
        }

        @Override
        public final Builder maximumUnits(Long maximumUnits) {
            this.maximumUnits = maximumUnits;
            return this;
        }

        public final void setMaximumUnits(Long maximumUnits) {
            this.maximumUnits = maximumUnits;
        }

        public final Boolean getAutoScalingDisabled() {
            return this.autoScalingDisabled;
        }

        @Override
        public final Builder autoScalingDisabled(Boolean autoScalingDisabled) {
            this.autoScalingDisabled = autoScalingDisabled;
            return this;
        }

        public final void setAutoScalingDisabled(Boolean autoScalingDisabled) {
            this.autoScalingDisabled = autoScalingDisabled;
        }

        public final String getAutoScalingRoleArn() {
            return this.autoScalingRoleArn;
        }

        @Override
        public final Builder autoScalingRoleArn(String autoScalingRoleArn) {
            this.autoScalingRoleArn = autoScalingRoleArn;
            return this;
        }

        public final void setAutoScalingRoleArn(String autoScalingRoleArn) {
            this.autoScalingRoleArn = autoScalingRoleArn;
        }

        public final AutoScalingPolicyUpdate.Builder getScalingPolicyUpdate() {
            return this.scalingPolicyUpdate != null ? this.scalingPolicyUpdate.toBuilder() : null;
        }

        @Override
        public final Builder scalingPolicyUpdate(AutoScalingPolicyUpdate scalingPolicyUpdate) {
            this.scalingPolicyUpdate = scalingPolicyUpdate;
            return this;
        }

        public final void setScalingPolicyUpdate(AutoScalingPolicyUpdate.BuilderImpl scalingPolicyUpdate) {
            this.scalingPolicyUpdate = scalingPolicyUpdate != null ? scalingPolicyUpdate.build() : null;
        }

        public AutoScalingSettingsUpdate build() {
            return new AutoScalingSettingsUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AutoScalingSettingsUpdate> {
        public Builder minimumUnits(Long var1);

        public Builder maximumUnits(Long var1);

        public Builder autoScalingDisabled(Boolean var1);

        public Builder autoScalingRoleArn(String var1);

        public Builder scalingPolicyUpdate(AutoScalingPolicyUpdate var1);

        default public Builder scalingPolicyUpdate(Consumer<AutoScalingPolicyUpdate.Builder> scalingPolicyUpdate) {
            return this.scalingPolicyUpdate((AutoScalingPolicyUpdate)((AutoScalingPolicyUpdate.Builder)AutoScalingPolicyUpdate.builder().applyMutation(scalingPolicyUpdate)).build());
        }
    }
}

