/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingTargetTrackingScalingPolicyConfigurationUpdate;
import software.amazon.awssdk.services.dynamodb.transform.AutoScalingPolicyUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingPolicyUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, AutoScalingPolicyUpdate> {
    private final String policyName;
    private final AutoScalingTargetTrackingScalingPolicyConfigurationUpdate targetTrackingScalingPolicyConfiguration;

    private AutoScalingPolicyUpdate(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.targetTrackingScalingPolicyConfiguration = builder.targetTrackingScalingPolicyConfiguration;
    }

    public String policyName() {
        return this.policyName;
    }

    public AutoScalingTargetTrackingScalingPolicyConfigurationUpdate targetTrackingScalingPolicyConfiguration() {
        return this.targetTrackingScalingPolicyConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTrackingScalingPolicyConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingPolicyUpdate)) {
            return false;
        }
        AutoScalingPolicyUpdate other = (AutoScalingPolicyUpdate)obj;
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.targetTrackingScalingPolicyConfiguration(), other.targetTrackingScalingPolicyConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"AutoScalingPolicyUpdate").add("PolicyName", (Object)this.policyName()).add("TargetTrackingScalingPolicyConfiguration", (Object)this.targetTrackingScalingPolicyConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "TargetTrackingScalingPolicyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetTrackingScalingPolicyConfiguration()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoScalingPolicyUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private AutoScalingTargetTrackingScalingPolicyConfigurationUpdate targetTrackingScalingPolicyConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingPolicyUpdate model) {
            this.policyName(model.policyName);
            this.targetTrackingScalingPolicyConfiguration(model.targetTrackingScalingPolicyConfiguration);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.Builder getTargetTrackingScalingPolicyConfiguration() {
            return this.targetTrackingScalingPolicyConfiguration != null ? this.targetTrackingScalingPolicyConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder targetTrackingScalingPolicyConfiguration(AutoScalingTargetTrackingScalingPolicyConfigurationUpdate targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration;
            return this;
        }

        public final void setTargetTrackingScalingPolicyConfiguration(AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.BuilderImpl targetTrackingScalingPolicyConfiguration) {
            this.targetTrackingScalingPolicyConfiguration = targetTrackingScalingPolicyConfiguration != null ? targetTrackingScalingPolicyConfiguration.build() : null;
        }

        public AutoScalingPolicyUpdate build() {
            return new AutoScalingPolicyUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AutoScalingPolicyUpdate> {
        public Builder policyName(String var1);

        public Builder targetTrackingScalingPolicyConfiguration(AutoScalingTargetTrackingScalingPolicyConfigurationUpdate var1);

        default public Builder targetTrackingScalingPolicyConfiguration(Consumer<AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.Builder> targetTrackingScalingPolicyConfiguration) {
            return this.targetTrackingScalingPolicyConfiguration((AutoScalingTargetTrackingScalingPolicyConfigurationUpdate)((AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.Builder)AutoScalingTargetTrackingScalingPolicyConfigurationUpdate.builder().applyMutation(targetTrackingScalingPolicyConfiguration)).build());
        }
    }
}

