/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.ReplicaSettingsDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReplicaSettingsDescriptionMarshaller {
    private static final MarshallingInfo<String> REGIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegionName").isBinary(false).build();
    private static final MarshallingInfo<String> REPLICASTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicaStatus").isBinary(false).build();
    private static final MarshallingInfo<Long> REPLICAPROVISIONEDREADCAPACITYUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicaProvisionedReadCapacityUnits").isBinary(false).build();
    private static final MarshallingInfo<Long> REPLICAPROVISIONEDWRITECAPACITYUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicaProvisionedWriteCapacityUnits").isBinary(false).build();
    private static final MarshallingInfo<List> REPLICAGLOBALSECONDARYINDEXSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReplicaGlobalSecondaryIndexSettings").isBinary(false).build();
    private static final ReplicaSettingsDescriptionMarshaller INSTANCE = new ReplicaSettingsDescriptionMarshaller();

    private ReplicaSettingsDescriptionMarshaller() {
    }

    public static ReplicaSettingsDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReplicaSettingsDescription replicaSettingsDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)replicaSettingsDescription, (String)"replicaSettingsDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)replicaSettingsDescription.regionName(), REGIONNAME_BINDING);
            protocolMarshaller.marshall((Object)replicaSettingsDescription.replicaStatusAsString(), REPLICASTATUS_BINDING);
            protocolMarshaller.marshall((Object)replicaSettingsDescription.replicaProvisionedReadCapacityUnits(), REPLICAPROVISIONEDREADCAPACITYUNITS_BINDING);
            protocolMarshaller.marshall((Object)replicaSettingsDescription.replicaProvisionedWriteCapacityUnits(), REPLICAPROVISIONEDWRITECAPACITYUNITS_BINDING);
            protocolMarshaller.marshall(replicaSettingsDescription.replicaGlobalSecondaryIndexSettings(), REPLICAGLOBALSECONDARYINDEXSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

