/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.Replica;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReplicaMarshaller {
    private static final MarshallingInfo<String> REGIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RegionName").isBinary(false).build();
    private static final ReplicaMarshaller INSTANCE = new ReplicaMarshaller();

    private ReplicaMarshaller() {
    }

    public static ReplicaMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Replica replica, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)replica, (String)"replica");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)replica.regionName(), REGIONNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

