/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.ListBackupsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListBackupsRequestModelMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Limit").isBinary(false).build();
    private static final MarshallingInfo<Instant> TIMERANGELOWERBOUND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeRangeLowerBound").isBinary(false).build();
    private static final MarshallingInfo<Instant> TIMERANGEUPPERBOUND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeRangeUpperBound").isBinary(false).build();
    private static final MarshallingInfo<String> EXCLUSIVESTARTBACKUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExclusiveStartBackupArn").isBinary(false).build();
    private static final ListBackupsRequestModelMarshaller INSTANCE = new ListBackupsRequestModelMarshaller();

    private ListBackupsRequestModelMarshaller() {
    }

    public static ListBackupsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListBackupsRequest listBackupsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listBackupsRequest), (String)"listBackupsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listBackupsRequest.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)listBackupsRequest.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall((Object)listBackupsRequest.timeRangeLowerBound(), TIMERANGELOWERBOUND_BINDING);
            protocolMarshaller.marshall((Object)listBackupsRequest.timeRangeUpperBound(), TIMERANGEUPPERBOUND_BINDING);
            protocolMarshaller.marshall((Object)listBackupsRequest.exclusiveStartBackupArn(), EXCLUSIVESTARTBACKUPARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

