/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;

public class ListTablesPublisher
implements SdkPublisher<ListTablesResponse> {
    private final DynamoDbAsyncClient client;
    private final ListTablesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTablesPublisher(DynamoDbAsyncClient client, ListTablesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTablesPublisher(DynamoDbAsyncClient client, ListTablesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTablesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTablesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> tableNames() {
        Function<ListTablesResponse, Iterator> getIterator = response -> {
            if (response != null && response.tableNames() != null) {
                return response.tableNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTablesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListTablesPublisher resume(ListTablesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTablesPublisher(this.client, (ListTablesRequest)((Object)this.firstRequest.toBuilder().exclusiveStartTableName(lastSuccessfulPage.lastEvaluatedTableName()).build()));
        }
        return new ListTablesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListTablesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListTablesResponseFetcher
    implements AsyncPageFetcher<ListTablesResponse> {
        private ListTablesResponseFetcher() {
        }

        public boolean hasNextPage(ListTablesResponse previousPage) {
            return previousPage.lastEvaluatedTableName() != null && !SdkAutoConstructList.class.isInstance(previousPage.lastEvaluatedTableName()) && !SdkAutoConstructMap.class.isInstance(previousPage.lastEvaluatedTableName());
        }

        public CompletableFuture<ListTablesResponse> nextPage(ListTablesResponse previousPage) {
            if (previousPage == null) {
                return ListTablesPublisher.this.client.listTables(ListTablesPublisher.this.firstRequest);
            }
            return ListTablesPublisher.this.client.listTables((ListTablesRequest)((Object)ListTablesPublisher.this.firstRequest.toBuilder().exclusiveStartTableName(previousPage.lastEvaluatedTableName()).build()));
        }
    }
}

