/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreTableFromBackupRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, RestoreTableFromBackupRequest> {
    private final String targetTableName;
    private final String backupArn;

    private RestoreTableFromBackupRequest(BuilderImpl builder) {
        super(builder);
        this.targetTableName = builder.targetTableName;
        this.backupArn = builder.backupArn;
    }

    public String targetTableName() {
        return this.targetTableName;
    }

    public String backupArn() {
        return this.backupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTableFromBackupRequest)) {
            return false;
        }
        RestoreTableFromBackupRequest other = (RestoreTableFromBackupRequest)((Object)obj);
        return Objects.equals(this.targetTableName(), other.targetTableName()) && Objects.equals(this.backupArn(), other.backupArn());
    }

    public String toString() {
        return ToString.builder((String)"RestoreTableFromBackupRequest").add("TargetTableName", (Object)this.targetTableName()).add("BackupArn", (Object)this.backupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetTableName": {
                return Optional.ofNullable(clazz.cast(this.targetTableName()));
            }
            case "BackupArn": {
                return Optional.ofNullable(clazz.cast(this.backupArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String targetTableName;
        private String backupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTableFromBackupRequest model) {
            super(model);
            this.targetTableName(model.targetTableName);
            this.backupArn(model.backupArn);
        }

        public final String getTargetTableName() {
            return this.targetTableName;
        }

        @Override
        public final Builder targetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
            return this;
        }

        public final void setTargetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
        }

        public final String getBackupArn() {
            return this.backupArn;
        }

        @Override
        public final Builder backupArn(String backupArn) {
            this.backupArn = backupArn;
            return this;
        }

        public final void setBackupArn(String backupArn) {
            this.backupArn = backupArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreTableFromBackupRequest build() {
            return new RestoreTableFromBackupRequest(this);
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    CopyableBuilder<Builder, RestoreTableFromBackupRequest> {
        public Builder targetTableName(String var1);

        public Builder backupArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

