/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGlobalTablesRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, ListGlobalTablesRequest> {
    private final String exclusiveStartGlobalTableName;
    private final Integer limit;
    private final String regionName;

    private ListGlobalTablesRequest(BuilderImpl builder) {
        super(builder);
        this.exclusiveStartGlobalTableName = builder.exclusiveStartGlobalTableName;
        this.limit = builder.limit;
        this.regionName = builder.regionName;
    }

    public String exclusiveStartGlobalTableName() {
        return this.exclusiveStartGlobalTableName;
    }

    public Integer limit() {
        return this.limit;
    }

    public String regionName() {
        return this.regionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartGlobalTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGlobalTablesRequest)) {
            return false;
        }
        ListGlobalTablesRequest other = (ListGlobalTablesRequest)((Object)obj);
        return Objects.equals(this.exclusiveStartGlobalTableName(), other.exclusiveStartGlobalTableName()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.regionName(), other.regionName());
    }

    public String toString() {
        return ToString.builder((String)"ListGlobalTablesRequest").add("ExclusiveStartGlobalTableName", (Object)this.exclusiveStartGlobalTableName()).add("Limit", (Object)this.limit()).add("RegionName", (Object)this.regionName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExclusiveStartGlobalTableName": {
                return Optional.ofNullable(clazz.cast(this.exclusiveStartGlobalTableName()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String exclusiveStartGlobalTableName;
        private Integer limit;
        private String regionName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGlobalTablesRequest model) {
            super(model);
            this.exclusiveStartGlobalTableName(model.exclusiveStartGlobalTableName);
            this.limit(model.limit);
            this.regionName(model.regionName);
        }

        public final String getExclusiveStartGlobalTableName() {
            return this.exclusiveStartGlobalTableName;
        }

        @Override
        public final Builder exclusiveStartGlobalTableName(String exclusiveStartGlobalTableName) {
            this.exclusiveStartGlobalTableName = exclusiveStartGlobalTableName;
            return this;
        }

        public final void setExclusiveStartGlobalTableName(String exclusiveStartGlobalTableName) {
            this.exclusiveStartGlobalTableName = exclusiveStartGlobalTableName;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGlobalTablesRequest build() {
            return new ListGlobalTablesRequest(this);
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    CopyableBuilder<Builder, ListGlobalTablesRequest> {
        public Builder exclusiveStartGlobalTableName(String var1);

        public Builder limit(Integer var1);

        public Builder regionName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

