/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableStatus;
import software.amazon.awssdk.services.dynamodb.model.ReplicaDescription;
import software.amazon.awssdk.services.dynamodb.model.ReplicaDescriptionListCopier;
import software.amazon.awssdk.services.dynamodb.transform.GlobalTableDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlobalTableDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, GlobalTableDescription> {
    private final List<ReplicaDescription> replicationGroup;
    private final String globalTableArn;
    private final Instant creationDateTime;
    private final String globalTableStatus;
    private final String globalTableName;

    private GlobalTableDescription(BuilderImpl builder) {
        this.replicationGroup = builder.replicationGroup;
        this.globalTableArn = builder.globalTableArn;
        this.creationDateTime = builder.creationDateTime;
        this.globalTableStatus = builder.globalTableStatus;
        this.globalTableName = builder.globalTableName;
    }

    public List<ReplicaDescription> replicationGroup() {
        return this.replicationGroup;
    }

    public String globalTableArn() {
        return this.globalTableArn;
    }

    public Instant creationDateTime() {
        return this.creationDateTime;
    }

    public GlobalTableStatus globalTableStatus() {
        return GlobalTableStatus.fromValue(this.globalTableStatus);
    }

    public String globalTableStatusAsString() {
        return this.globalTableStatus;
    }

    public String globalTableName() {
        return this.globalTableName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTableStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTableName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalTableDescription)) {
            return false;
        }
        GlobalTableDescription other = (GlobalTableDescription)obj;
        return Objects.equals(this.replicationGroup(), other.replicationGroup()) && Objects.equals(this.globalTableArn(), other.globalTableArn()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.globalTableStatusAsString(), other.globalTableStatusAsString()) && Objects.equals(this.globalTableName(), other.globalTableName());
    }

    public String toString() {
        return ToString.builder((String)"GlobalTableDescription").add("ReplicationGroup", this.replicationGroup()).add("GlobalTableArn", (Object)this.globalTableArn()).add("CreationDateTime", (Object)this.creationDateTime()).add("GlobalTableStatus", (Object)this.globalTableStatusAsString()).add("GlobalTableName", (Object)this.globalTableName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroup": {
                return Optional.ofNullable(clazz.cast(this.replicationGroup()));
            }
            case "GlobalTableArn": {
                return Optional.ofNullable(clazz.cast(this.globalTableArn()));
            }
            case "CreationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "GlobalTableStatus": {
                return Optional.ofNullable(clazz.cast(this.globalTableStatusAsString()));
            }
            case "GlobalTableName": {
                return Optional.ofNullable(clazz.cast(this.globalTableName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GlobalTableDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ReplicaDescription> replicationGroup = DefaultSdkAutoConstructList.getInstance();
        private String globalTableArn;
        private Instant creationDateTime;
        private String globalTableStatus;
        private String globalTableName;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalTableDescription model) {
            this.replicationGroup(model.replicationGroup);
            this.globalTableArn(model.globalTableArn);
            this.creationDateTime(model.creationDateTime);
            this.globalTableStatus(model.globalTableStatus);
            this.globalTableName(model.globalTableName);
        }

        public final Collection<ReplicaDescription.Builder> getReplicationGroup() {
            return this.replicationGroup != null ? (Collection)this.replicationGroup.stream().map(ReplicaDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationGroup(Collection<ReplicaDescription> replicationGroup) {
            this.replicationGroup = ReplicaDescriptionListCopier.copy(replicationGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroup(ReplicaDescription ... replicationGroup) {
            this.replicationGroup(Arrays.asList(replicationGroup));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroup(Consumer<ReplicaDescription.Builder> ... replicationGroup) {
            this.replicationGroup(Stream.of(replicationGroup).map(c -> (ReplicaDescription)((ReplicaDescription.Builder)ReplicaDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationGroup(Collection<ReplicaDescription.BuilderImpl> replicationGroup) {
            this.replicationGroup = ReplicaDescriptionListCopier.copyFromBuilder(replicationGroup);
        }

        public final String getGlobalTableArn() {
            return this.globalTableArn;
        }

        @Override
        public final Builder globalTableArn(String globalTableArn) {
            this.globalTableArn = globalTableArn;
            return this;
        }

        public final void setGlobalTableArn(String globalTableArn) {
            this.globalTableArn = globalTableArn;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final String getGlobalTableStatus() {
            return this.globalTableStatus;
        }

        @Override
        public final Builder globalTableStatus(String globalTableStatus) {
            this.globalTableStatus = globalTableStatus;
            return this;
        }

        @Override
        public final Builder globalTableStatus(GlobalTableStatus globalTableStatus) {
            this.globalTableStatus(globalTableStatus.toString());
            return this;
        }

        public final void setGlobalTableStatus(String globalTableStatus) {
            this.globalTableStatus = globalTableStatus;
        }

        public final String getGlobalTableName() {
            return this.globalTableName;
        }

        @Override
        public final Builder globalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
            return this;
        }

        public final void setGlobalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
        }

        public GlobalTableDescription build() {
            return new GlobalTableDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GlobalTableDescription> {
        public Builder replicationGroup(Collection<ReplicaDescription> var1);

        public Builder replicationGroup(ReplicaDescription ... var1);

        public Builder replicationGroup(Consumer<ReplicaDescription.Builder> ... var1);

        public Builder globalTableArn(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder globalTableStatus(String var1);

        public Builder globalTableStatus(GlobalTableStatus var1);

        public Builder globalTableName(String var1);
    }
}

