/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsStatus;
import software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryDescription;
import software.amazon.awssdk.services.dynamodb.transform.ContinuousBackupsDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContinuousBackupsDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, ContinuousBackupsDescription> {
    private final String continuousBackupsStatus;
    private final PointInTimeRecoveryDescription pointInTimeRecoveryDescription;

    private ContinuousBackupsDescription(BuilderImpl builder) {
        this.continuousBackupsStatus = builder.continuousBackupsStatus;
        this.pointInTimeRecoveryDescription = builder.pointInTimeRecoveryDescription;
    }

    public ContinuousBackupsStatus continuousBackupsStatus() {
        return ContinuousBackupsStatus.fromValue(this.continuousBackupsStatus);
    }

    public String continuousBackupsStatusAsString() {
        return this.continuousBackupsStatus;
    }

    public PointInTimeRecoveryDescription pointInTimeRecoveryDescription() {
        return this.pointInTimeRecoveryDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.continuousBackupsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pointInTimeRecoveryDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinuousBackupsDescription)) {
            return false;
        }
        ContinuousBackupsDescription other = (ContinuousBackupsDescription)obj;
        return Objects.equals(this.continuousBackupsStatusAsString(), other.continuousBackupsStatusAsString()) && Objects.equals(this.pointInTimeRecoveryDescription(), other.pointInTimeRecoveryDescription());
    }

    public String toString() {
        return ToString.builder((String)"ContinuousBackupsDescription").add("ContinuousBackupsStatus", (Object)this.continuousBackupsStatusAsString()).add("PointInTimeRecoveryDescription", (Object)this.pointInTimeRecoveryDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContinuousBackupsStatus": {
                return Optional.ofNullable(clazz.cast(this.continuousBackupsStatusAsString()));
            }
            case "PointInTimeRecoveryDescription": {
                return Optional.ofNullable(clazz.cast(this.pointInTimeRecoveryDescription()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContinuousBackupsDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String continuousBackupsStatus;
        private PointInTimeRecoveryDescription pointInTimeRecoveryDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ContinuousBackupsDescription model) {
            this.continuousBackupsStatus(model.continuousBackupsStatus);
            this.pointInTimeRecoveryDescription(model.pointInTimeRecoveryDescription);
        }

        public final String getContinuousBackupsStatus() {
            return this.continuousBackupsStatus;
        }

        @Override
        public final Builder continuousBackupsStatus(String continuousBackupsStatus) {
            this.continuousBackupsStatus = continuousBackupsStatus;
            return this;
        }

        @Override
        public final Builder continuousBackupsStatus(ContinuousBackupsStatus continuousBackupsStatus) {
            this.continuousBackupsStatus(continuousBackupsStatus.toString());
            return this;
        }

        public final void setContinuousBackupsStatus(String continuousBackupsStatus) {
            this.continuousBackupsStatus = continuousBackupsStatus;
        }

        public final PointInTimeRecoveryDescription.Builder getPointInTimeRecoveryDescription() {
            return this.pointInTimeRecoveryDescription != null ? this.pointInTimeRecoveryDescription.toBuilder() : null;
        }

        @Override
        public final Builder pointInTimeRecoveryDescription(PointInTimeRecoveryDescription pointInTimeRecoveryDescription) {
            this.pointInTimeRecoveryDescription = pointInTimeRecoveryDescription;
            return this;
        }

        public final void setPointInTimeRecoveryDescription(PointInTimeRecoveryDescription.BuilderImpl pointInTimeRecoveryDescription) {
            this.pointInTimeRecoveryDescription = pointInTimeRecoveryDescription != null ? pointInTimeRecoveryDescription.build() : null;
        }

        public ContinuousBackupsDescription build() {
            return new ContinuousBackupsDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ContinuousBackupsDescription> {
        public Builder continuousBackupsStatus(String var1);

        public Builder continuousBackupsStatus(ContinuousBackupsStatus var1);

        public Builder pointInTimeRecoveryDescription(PointInTimeRecoveryDescription var1);

        default public Builder pointInTimeRecoveryDescription(Consumer<PointInTimeRecoveryDescription.Builder> pointInTimeRecoveryDescription) {
            return this.pointInTimeRecoveryDescription((PointInTimeRecoveryDescription)((PointInTimeRecoveryDescription.Builder)PointInTimeRecoveryDescription.builder().applyMutation(pointInTimeRecoveryDescription)).build());
        }
    }
}

