/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TableDescriptionMarshaller {
    private static final MarshallingInfo<List> ATTRIBUTEDEFINITIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeDefinitions").isBinary(false).build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<List> KEYSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeySchema").isBinary(false).build();
    private static final MarshallingInfo<String> TABLESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableStatus").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDateTime").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PROVISIONEDTHROUGHPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionedThroughput").isBinary(false).build();
    private static final MarshallingInfo<Long> TABLESIZEBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableSizeBytes").isBinary(false).build();
    private static final MarshallingInfo<Long> ITEMCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ItemCount").isBinary(false).build();
    private static final MarshallingInfo<String> TABLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableArn").isBinary(false).build();
    private static final MarshallingInfo<List> LOCALSECONDARYINDEXES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocalSecondaryIndexes").isBinary(false).build();
    private static final MarshallingInfo<List> GLOBALSECONDARYINDEXES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlobalSecondaryIndexes").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STREAMSPECIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamSpecification").isBinary(false).build();
    private static final MarshallingInfo<String> LATESTSTREAMLABEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestStreamLabel").isBinary(false).build();
    private static final MarshallingInfo<String> LATESTSTREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestStreamArn").isBinary(false).build();
    private static final TableDescriptionMarshaller INSTANCE = new TableDescriptionMarshaller();

    private TableDescriptionMarshaller() {
    }

    public static TableDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TableDescription tableDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)tableDescription, (String)"tableDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(tableDescription.attributeDefinitions(), ATTRIBUTEDEFINITIONS_BINDING);
            protocolMarshaller.marshall((Object)tableDescription.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(tableDescription.keySchema(), KEYSCHEMA_BINDING);
            protocolMarshaller.marshall((Object)tableDescription.tableStatusAsString(), TABLESTATUS_BINDING);
            protocolMarshaller.marshall((Object)tableDescription.creationDateTime(), CREATIONDATETIME_BINDING);
            protocolMarshaller.marshall((Object)tableDescription.provisionedThroughput(), PROVISIONEDTHROUGHPUT_BINDING);
            protocolMarshaller.marshall((Object)tableDescription.tableSizeBytes(), TABLESIZEBYTES_BINDING);
            protocolMarshaller.marshall((Object)tableDescription.itemCount(), ITEMCOUNT_BINDING);
            protocolMarshaller.marshall((Object)tableDescription.tableArn(), TABLEARN_BINDING);
            protocolMarshaller.marshall(tableDescription.localSecondaryIndexes(), LOCALSECONDARYINDEXES_BINDING);
            protocolMarshaller.marshall(tableDescription.globalSecondaryIndexes(), GLOBALSECONDARYINDEXES_BINDING);
            protocolMarshaller.marshall((Object)tableDescription.streamSpecification(), STREAMSPECIFICATION_BINDING);
            protocolMarshaller.marshall((Object)tableDescription.latestStreamLabel(), LATESTSTREAMLABEL_BINDING);
            protocolMarshaller.marshall((Object)tableDescription.latestStreamArn(), LATESTSTREAMARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

