/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.transform.AttributeValueUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ConsumedCapacityUnmarshaller;

public class ScanResponseUnmarshaller
implements Unmarshaller<ScanResponse, JsonUnmarshallerContext> {
    private static final ScanResponseUnmarshaller INSTANCE = new ScanResponseUnmarshaller();

    public ScanResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        ScanResponse.Builder scanResponseBuilder = ScanResponse.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return (ScanResponse)((Object)scanResponseBuilder.build());
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Items", targetDepth)) {
                    context.nextToken();
                    scanResponseBuilder.items(new ListUnmarshaller((Unmarshaller)new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)AttributeValueUnmarshaller.getInstance())).unmarshall(context));
                }
                if (context.testExpression("Count", targetDepth)) {
                    context.nextToken();
                    scanResponseBuilder.count((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("ScannedCount", targetDepth)) {
                    context.nextToken();
                    scanResponseBuilder.scannedCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastEvaluatedKey", targetDepth)) {
                    context.nextToken();
                    scanResponseBuilder.lastEvaluatedKey(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)AttributeValueUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ConsumedCapacity", targetDepth)) {
                    context.nextToken();
                    scanResponseBuilder.consumedCapacity(ConsumedCapacityUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ScanResponse)((Object)scanResponseBuilder.build());
    }

    public static ScanResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

