/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutItemRequestModelMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<Map> ITEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Item").isBinary(false).build();
    private static final MarshallingInfo<Map> EXPECTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Expected").isBinary(false).build();
    private static final MarshallingInfo<String> RETURNVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReturnValues").isBinary(false).build();
    private static final MarshallingInfo<String> RETURNCONSUMEDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReturnConsumedCapacity").isBinary(false).build();
    private static final MarshallingInfo<String> RETURNITEMCOLLECTIONMETRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReturnItemCollectionMetrics").isBinary(false).build();
    private static final MarshallingInfo<String> CONDITIONALOPERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConditionalOperator").isBinary(false).build();
    private static final MarshallingInfo<String> CONDITIONEXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConditionExpression").isBinary(false).build();
    private static final MarshallingInfo<Map> EXPRESSIONATTRIBUTENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpressionAttributeNames").isBinary(false).build();
    private static final MarshallingInfo<Map> EXPRESSIONATTRIBUTEVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpressionAttributeValues").isBinary(false).build();
    private static final PutItemRequestModelMarshaller INSTANCE = new PutItemRequestModelMarshaller();

    private PutItemRequestModelMarshaller() {
    }

    public static PutItemRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutItemRequest putItemRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)putItemRequest), (String)"putItemRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)putItemRequest.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(putItemRequest.item(), ITEM_BINDING);
            protocolMarshaller.marshall(putItemRequest.expected(), EXPECTED_BINDING);
            protocolMarshaller.marshall((Object)putItemRequest.returnValuesAsString(), RETURNVALUES_BINDING);
            protocolMarshaller.marshall((Object)putItemRequest.returnConsumedCapacityAsString(), RETURNCONSUMEDCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)putItemRequest.returnItemCollectionMetricsAsString(), RETURNITEMCOLLECTIONMETRICS_BINDING);
            protocolMarshaller.marshall((Object)putItemRequest.conditionalOperatorAsString(), CONDITIONALOPERATOR_BINDING);
            protocolMarshaller.marshall((Object)putItemRequest.conditionExpression(), CONDITIONEXPRESSION_BINDING);
            protocolMarshaller.marshall(putItemRequest.expressionAttributeNames(), EXPRESSIONATTRIBUTENAMES_BINDING);
            protocolMarshaller.marshall(putItemRequest.expressionAttributeValues(), EXPRESSIONATTRIBUTEVALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

