/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.dynamodb.model.DynamoDBStreamsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeStreamRequest
extends DynamoDBStreamsRequest
implements ToCopyableBuilder<Builder, DescribeStreamRequest> {
    private final String streamArn;
    private final Integer limit;
    private final String exclusiveStartShardId;

    private DescribeStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamArn = builder.streamArn;
        this.limit = builder.limit;
        this.exclusiveStartShardId = builder.exclusiveStartShardId;
    }

    public String streamArn() {
        return this.streamArn;
    }

    public Integer limit() {
        return this.limit;
    }

    public String exclusiveStartShardId() {
        return this.exclusiveStartShardId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartShardId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamRequest)) {
            return false;
        }
        DescribeStreamRequest other = (DescribeStreamRequest)((Object)obj);
        return Objects.equals(this.streamArn(), other.streamArn()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.exclusiveStartShardId(), other.exclusiveStartShardId());
    }

    public String toString() {
        return ToString.builder((String)"DescribeStreamRequest").add("StreamArn", (Object)this.streamArn()).add("Limit", (Object)this.limit()).add("ExclusiveStartShardId", (Object)this.exclusiveStartShardId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamArn": {
                return Optional.of(clazz.cast(this.streamArn()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "ExclusiveStartShardId": {
                return Optional.of(clazz.cast(this.exclusiveStartShardId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDBStreamsRequest.BuilderImpl
    implements Builder {
        private String streamArn;
        private Integer limit;
        private String exclusiveStartShardId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamRequest model) {
            super(model);
            this.streamArn(model.streamArn);
            this.limit(model.limit);
            this.exclusiveStartShardId(model.exclusiveStartShardId);
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartShardId() {
            return this.exclusiveStartShardId;
        }

        @Override
        public final Builder exclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
            return this;
        }

        public final void setExclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeStreamRequest build() {
            return new DescribeStreamRequest(this);
        }
    }

    public static interface Builder
    extends DynamoDBStreamsRequest.Builder,
    CopyableBuilder<Builder, DescribeStreamRequest> {
        public Builder streamArn(String var1);

        public Builder limit(Integer var1);

        public Builder exclusiveStartShardId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

