/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.util.Date;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.services.dynamodb.transform.AttributeDefinitionUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.GlobalSecondaryIndexDescriptionUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.KeySchemaElementUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.LocalSecondaryIndexDescriptionUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ProvisionedThroughputDescriptionUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.StreamSpecificationUnmarshaller;

public class TableDescriptionUnmarshaller
implements Unmarshaller<TableDescription, JsonUnmarshallerContext> {
    private static TableDescriptionUnmarshaller INSTANCE;

    public TableDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        TableDescription.Builder tableDescriptionBuilder = TableDescription.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("AttributeDefinitions", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.attributeDefinitions(new ListUnmarshaller((Unmarshaller)AttributeDefinitionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("TableName", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.tableName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KeySchema", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.keySchema(new ListUnmarshaller((Unmarshaller)KeySchemaElementUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("TableStatus", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.tableStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationDateTime", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.creationDateTime((Date)context.getUnmarshaller(Date.class).unmarshall((Object)context));
                }
                if (context.testExpression("ProvisionedThroughput", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.provisionedThroughput(ProvisionedThroughputDescriptionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("TableSizeBytes", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.tableSizeBytes((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("ItemCount", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.itemCount((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("TableArn", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.tableArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LocalSecondaryIndexes", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.localSecondaryIndexes(new ListUnmarshaller((Unmarshaller)LocalSecondaryIndexDescriptionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("GlobalSecondaryIndexes", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.globalSecondaryIndexes(new ListUnmarshaller((Unmarshaller)GlobalSecondaryIndexDescriptionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("StreamSpecification", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.streamSpecification(StreamSpecificationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LatestStreamLabel", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.latestStreamLabel((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LatestStreamArn", targetDepth)) {
                    context.nextToken();
                    tableDescriptionBuilder.latestStreamArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TableDescription)tableDescriptionBuilder.build();
    }

    public static TableDescriptionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TableDescriptionUnmarshaller();
        }
        return INSTANCE;
    }
}

