/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.Shard;
import software.amazon.awssdk.services.dynamodb.model.ShardDescriptionListCopier;
import software.amazon.awssdk.services.dynamodb.model.StreamStatus;
import software.amazon.awssdk.services.dynamodb.model.StreamViewType;
import software.amazon.awssdk.services.dynamodb.transform.StreamDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StreamDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, StreamDescription> {
    private final String streamArn;
    private final String streamLabel;
    private final String streamStatus;
    private final String streamViewType;
    private final Date creationRequestDateTime;
    private final String tableName;
    private final List<KeySchemaElement> keySchema;
    private final List<Shard> shards;
    private final String lastEvaluatedShardId;

    private StreamDescription(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.streamLabel = builder.streamLabel;
        this.streamStatus = builder.streamStatus;
        this.streamViewType = builder.streamViewType;
        this.creationRequestDateTime = builder.creationRequestDateTime;
        this.tableName = builder.tableName;
        this.keySchema = builder.keySchema;
        this.shards = builder.shards;
        this.lastEvaluatedShardId = builder.lastEvaluatedShardId;
    }

    public String streamArn() {
        return this.streamArn;
    }

    public String streamLabel() {
        return this.streamLabel;
    }

    public String streamStatus() {
        return this.streamStatus;
    }

    public String streamViewType() {
        return this.streamViewType;
    }

    public Date creationRequestDateTime() {
        return this.creationRequestDateTime;
    }

    public String tableName() {
        return this.tableName;
    }

    public List<KeySchemaElement> keySchema() {
        return this.keySchema;
    }

    public List<Shard> shards() {
        return this.shards;
    }

    public String lastEvaluatedShardId() {
        return this.lastEvaluatedShardId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.streamArn() == null ? 0 : this.streamArn().hashCode());
        hashCode = 31 * hashCode + (this.streamLabel() == null ? 0 : this.streamLabel().hashCode());
        hashCode = 31 * hashCode + (this.streamStatus() == null ? 0 : this.streamStatus().hashCode());
        hashCode = 31 * hashCode + (this.streamViewType() == null ? 0 : this.streamViewType().hashCode());
        hashCode = 31 * hashCode + (this.creationRequestDateTime() == null ? 0 : this.creationRequestDateTime().hashCode());
        hashCode = 31 * hashCode + (this.tableName() == null ? 0 : this.tableName().hashCode());
        hashCode = 31 * hashCode + (this.keySchema() == null ? 0 : this.keySchema().hashCode());
        hashCode = 31 * hashCode + (this.shards() == null ? 0 : this.shards().hashCode());
        hashCode = 31 * hashCode + (this.lastEvaluatedShardId() == null ? 0 : this.lastEvaluatedShardId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamDescription)) {
            return false;
        }
        StreamDescription other = (StreamDescription)obj;
        if (other.streamArn() == null ^ this.streamArn() == null) {
            return false;
        }
        if (other.streamArn() != null && !other.streamArn().equals(this.streamArn())) {
            return false;
        }
        if (other.streamLabel() == null ^ this.streamLabel() == null) {
            return false;
        }
        if (other.streamLabel() != null && !other.streamLabel().equals(this.streamLabel())) {
            return false;
        }
        if (other.streamStatus() == null ^ this.streamStatus() == null) {
            return false;
        }
        if (other.streamStatus() != null && !other.streamStatus().equals(this.streamStatus())) {
            return false;
        }
        if (other.streamViewType() == null ^ this.streamViewType() == null) {
            return false;
        }
        if (other.streamViewType() != null && !other.streamViewType().equals(this.streamViewType())) {
            return false;
        }
        if (other.creationRequestDateTime() == null ^ this.creationRequestDateTime() == null) {
            return false;
        }
        if (other.creationRequestDateTime() != null && !other.creationRequestDateTime().equals(this.creationRequestDateTime())) {
            return false;
        }
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.keySchema() == null ^ this.keySchema() == null) {
            return false;
        }
        if (other.keySchema() != null && !other.keySchema().equals(this.keySchema())) {
            return false;
        }
        if (other.shards() == null ^ this.shards() == null) {
            return false;
        }
        if (other.shards() != null && !other.shards().equals(this.shards())) {
            return false;
        }
        if (other.lastEvaluatedShardId() == null ^ this.lastEvaluatedShardId() == null) {
            return false;
        }
        return other.lastEvaluatedShardId() == null || other.lastEvaluatedShardId().equals(this.lastEvaluatedShardId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.streamArn() != null) {
            sb.append("StreamArn: ").append(this.streamArn()).append(",");
        }
        if (this.streamLabel() != null) {
            sb.append("StreamLabel: ").append(this.streamLabel()).append(",");
        }
        if (this.streamStatus() != null) {
            sb.append("StreamStatus: ").append(this.streamStatus()).append(",");
        }
        if (this.streamViewType() != null) {
            sb.append("StreamViewType: ").append(this.streamViewType()).append(",");
        }
        if (this.creationRequestDateTime() != null) {
            sb.append("CreationRequestDateTime: ").append(this.creationRequestDateTime()).append(",");
        }
        if (this.tableName() != null) {
            sb.append("TableName: ").append(this.tableName()).append(",");
        }
        if (this.keySchema() != null) {
            sb.append("KeySchema: ").append(this.keySchema()).append(",");
        }
        if (this.shards() != null) {
            sb.append("Shards: ").append(this.shards()).append(",");
        }
        if (this.lastEvaluatedShardId() != null) {
            sb.append("LastEvaluatedShardId: ").append(this.lastEvaluatedShardId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String streamArn;
        private String streamLabel;
        private String streamStatus;
        private String streamViewType;
        private Date creationRequestDateTime;
        private String tableName;
        private List<KeySchemaElement> keySchema;
        private List<Shard> shards;
        private String lastEvaluatedShardId;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamDescription model) {
            this.setStreamArn(model.streamArn);
            this.setStreamLabel(model.streamLabel);
            this.setStreamStatus(model.streamStatus);
            this.setStreamViewType(model.streamViewType);
            this.setCreationRequestDateTime(model.creationRequestDateTime);
            this.setTableName(model.tableName);
            this.setKeySchema(model.keySchema);
            this.setShards(model.shards);
            this.setLastEvaluatedShardId(model.lastEvaluatedShardId);
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final String getStreamLabel() {
            return this.streamLabel;
        }

        @Override
        public final Builder streamLabel(String streamLabel) {
            this.streamLabel = streamLabel;
            return this;
        }

        public final void setStreamLabel(String streamLabel) {
            this.streamLabel = streamLabel;
        }

        public final String getStreamStatus() {
            return this.streamStatus;
        }

        @Override
        public final Builder streamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
            return this;
        }

        @Override
        public final Builder streamStatus(StreamStatus streamStatus) {
            this.streamStatus(streamStatus.toString());
            return this;
        }

        public final void setStreamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
        }

        public final void setStreamStatus(StreamStatus streamStatus) {
            this.streamStatus(streamStatus.toString());
        }

        public final String getStreamViewType() {
            return this.streamViewType;
        }

        @Override
        public final Builder streamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
            return this;
        }

        @Override
        public final Builder streamViewType(StreamViewType streamViewType) {
            this.streamViewType(streamViewType.toString());
            return this;
        }

        public final void setStreamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
        }

        public final void setStreamViewType(StreamViewType streamViewType) {
            this.streamViewType(streamViewType.toString());
        }

        public final Date getCreationRequestDateTime() {
            return this.creationRequestDateTime;
        }

        @Override
        public final Builder creationRequestDateTime(Date creationRequestDateTime) {
            this.creationRequestDateTime = StandardMemberCopier.copy((Date)creationRequestDateTime);
            return this;
        }

        public final void setCreationRequestDateTime(Date creationRequestDateTime) {
            this.creationRequestDateTime = StandardMemberCopier.copy((Date)creationRequestDateTime);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Collection<KeySchemaElement> getKeySchema() {
            return this.keySchema;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement ... keySchema) {
            if (this.keySchema == null) {
                this.keySchema = new ArrayList<KeySchemaElement>(keySchema.length);
            }
            for (KeySchemaElement e : keySchema) {
                this.keySchema.add(e);
            }
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
        }

        @SafeVarargs
        public final void setKeySchema(KeySchemaElement ... keySchema) {
            if (this.keySchema == null) {
                this.keySchema = new ArrayList<KeySchemaElement>(keySchema.length);
            }
            for (KeySchemaElement e : keySchema) {
                this.keySchema.add(e);
            }
        }

        public final Collection<Shard> getShards() {
            return this.shards;
        }

        @Override
        public final Builder shards(Collection<Shard> shards) {
            this.shards = ShardDescriptionListCopier.copy(shards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Shard ... shards) {
            if (this.shards == null) {
                this.shards = new ArrayList<Shard>(shards.length);
            }
            for (Shard e : shards) {
                this.shards.add(e);
            }
            return this;
        }

        public final void setShards(Collection<Shard> shards) {
            this.shards = ShardDescriptionListCopier.copy(shards);
        }

        @SafeVarargs
        public final void setShards(Shard ... shards) {
            if (this.shards == null) {
                this.shards = new ArrayList<Shard>(shards.length);
            }
            for (Shard e : shards) {
                this.shards.add(e);
            }
        }

        public final String getLastEvaluatedShardId() {
            return this.lastEvaluatedShardId;
        }

        @Override
        public final Builder lastEvaluatedShardId(String lastEvaluatedShardId) {
            this.lastEvaluatedShardId = lastEvaluatedShardId;
            return this;
        }

        public final void setLastEvaluatedShardId(String lastEvaluatedShardId) {
            this.lastEvaluatedShardId = lastEvaluatedShardId;
        }

        public StreamDescription build() {
            return new StreamDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StreamDescription> {
        public Builder streamArn(String var1);

        public Builder streamLabel(String var1);

        public Builder streamStatus(String var1);

        public Builder streamStatus(StreamStatus var1);

        public Builder streamViewType(String var1);

        public Builder streamViewType(StreamViewType var1);

        public Builder creationRequestDateTime(Date var1);

        public Builder tableName(String var1);

        public Builder keySchema(Collection<KeySchemaElement> var1);

        public Builder keySchema(KeySchemaElement ... var1);

        public Builder shards(Collection<Shard> var1);

        public Builder shards(Shard ... var1);

        public Builder lastEvaluatedShardId(String var1);
    }
}

