/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.internal;

import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.document.Page;
import software.amazon.awssdk.services.dynamodb.document.Table;
import software.amazon.awssdk.services.dynamodb.document.TableCollection;
import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;
import software.amazon.awssdk.services.dynamodb.document.internal.ListTablesPage;
import software.amazon.awssdk.services.dynamodb.document.spec.ListTablesSpec;
import software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;

class ListTablesCollection
extends TableCollection<ListTablesResponse> {
    private final DynamoDBClient client;
    private final ListTablesSpec spec;
    private final String startKey;

    public ListTablesCollection(DynamoDBClient client, ListTablesSpec spec) {
        this.client = client;
        this.spec = spec;
        this.startKey = spec.getExclusiveStartTableName();
    }

    @Override
    public Page<Table, ListTablesResponse> firstPage() {
        ListTablesRequest request = (ListTablesRequest)((Object)((ListTablesRequest)((Object)this.spec.getRequest())).toBuilder().exclusiveStartTableName(this.startKey).limit(InternalUtils.minimum(this.spec.maxResultSize(), this.spec.maxPageSize())).build());
        this.spec.setRequest(request);
        ListTablesResponse result = this.client.listTables(request);
        this.setLastLowLevelResult(result);
        return new ListTablesPage(this.client, this.spec, request, 0, result);
    }

    @Override
    public Integer getMaxResultSize() {
        return this.spec.maxResultSize();
    }
}

