/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers;

import java.lang.reflect.Method;
import software.amazon.awssdk.services.dynamodb.datamodeling.ArgumentUnmarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMappingException;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class BooleanUnmarshaller
implements ArgumentUnmarshaller {
    private static final BooleanUnmarshaller INSTANCE = new BooleanUnmarshaller();

    private BooleanUnmarshaller() {
    }

    public static BooleanUnmarshaller instance() {
        return INSTANCE;
    }

    @Override
    public void typeCheck(AttributeValue value, Method setter) {
        if (value.n() == null && value.bool() == null) {
            throw new DynamoDbMappingException("Expected either N or BOOL in value " + value + " when invoking " + setter);
        }
    }

    @Override
    public Object unmarshall(AttributeValue value) {
        if (value.bool() != null) {
            return value.bool();
        }
        if ("1".equals(value.n())) {
            return Boolean.TRUE;
        }
        if ("0".equals(value.n())) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Expected '1', '0', or BOOL value for boolean value, was " + value);
    }
}

