/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.auth.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class S3ClientCache {
    private final ConcurrentMap<String, S3Client> clientsByRegion = new ConcurrentHashMap<String, S3Client>();
    private final AwsCredentialsProvider awscredentialsProvider;

    @Deprecated
    S3ClientCache(AwsCredentials credentials) {
        this((AwsCredentialsProvider)new StaticCredentialsProvider(credentials));
    }

    S3ClientCache(AwsCredentialsProvider awsCredentialsProvider) {
        this.awscredentialsProvider = awsCredentialsProvider;
    }

    public void useClient(S3Client client, Region region) {
        this.clientsByRegion.put(region.value(), client);
    }

    public S3Client getClient(Region region) {
        if (region == null) {
            throw new IllegalArgumentException("S3 region must be specified");
        }
        return this.getClient(region.value());
    }

    public S3Client getClient(String region) {
        if (region == null) {
            throw new IllegalArgumentException("S3 region must be specified");
        }
        S3Client client = (S3Client)this.clientsByRegion.get(region);
        return client != null ? client : this.cacheClient(region);
    }

    private S3Client cacheClient(String region) {
        if (this.awscredentialsProvider == null) {
            throw new IllegalArgumentException("No credentials provider found to connect to S3");
        }
        S3Client client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider(this.awscredentialsProvider)).region(Region.of((String)region))).build();
        this.clientsByRegion.put(region, client);
        return client;
    }
}

