/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperFieldModel;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMappingException;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverter;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardBeanProperties;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;

public final class DynamoDbMapperTableModel<T>
implements DynamoDbTypeConverter<Map<String, AttributeValue>, T> {
    private final Map<String, GlobalSecondaryIndex> globalSecondaryIndexes;
    private final Map<String, LocalSecondaryIndex> localSecondaryIndexes;
    private final Map<String, DynamoDbMapperFieldModel<T, Object>> versions;
    private final Map<String, DynamoDbMapperFieldModel<T, Object>> fields;
    private final Map<KeyType, DynamoDbMapperFieldModel<T, Object>> keys;
    private final Class<T> targetType;

    private DynamoDbMapperTableModel(Builder<T> builder) {
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes();
        this.localSecondaryIndexes = builder.localSecondaryIndexes();
        this.versions = ((Builder)builder).versions();
        this.fields = builder.fields();
        this.keys = builder.keys();
        this.targetType = ((Builder)builder).targetType;
    }

    public Class<T> targetType() {
        return this.targetType;
    }

    public Collection<DynamoDbMapperFieldModel<T, Object>> fields() {
        return this.fields.values();
    }

    public <V> DynamoDbMapperFieldModel<T, V> field(String attributeName) {
        DynamoDbMapperFieldModel<T, Object> field = this.fields.get(attributeName);
        if (field == null) {
            throw new DynamoDbMappingException(this.targetType.getSimpleName() + "[" + attributeName + "]; no mapping for attribute by name");
        }
        return field;
    }

    public Collection<DynamoDbMapperFieldModel<T, Object>> keys() {
        return this.keys.values();
    }

    public <H> DynamoDbMapperFieldModel<T, H> hashKey() {
        DynamoDbMapperFieldModel<T, Object> field = this.keys.get((Object)KeyType.HASH);
        if (field == null) {
            throw new DynamoDbMappingException(this.targetType.getSimpleName() + "; no mapping for HASH key");
        }
        return field;
    }

    public <R> DynamoDbMapperFieldModel<T, R> rangeKey() {
        DynamoDbMapperFieldModel<T, Object> field = this.keys.get((Object)KeyType.RANGE);
        if (field == null) {
            throw new DynamoDbMappingException(this.targetType.getSimpleName() + "; no mapping for RANGE key");
        }
        return field;
    }

    public <R> DynamoDbMapperFieldModel<T, R> rangeKeyIfExists() {
        return this.keys.get((Object)KeyType.RANGE);
    }

    public Collection<DynamoDbMapperFieldModel<T, Object>> versions() {
        return this.versions.values();
    }

    public boolean versioned() {
        return !this.versions.isEmpty();
    }

    public Collection<GlobalSecondaryIndex> globalSecondaryIndexes() {
        if (this.globalSecondaryIndexes.isEmpty()) {
            return null;
        }
        ArrayList<GlobalSecondaryIndex> copies = new ArrayList<GlobalSecondaryIndex>(this.globalSecondaryIndexes.size());
        for (String indexName : this.globalSecondaryIndexes.keySet()) {
            copies.add(this.globalSecondaryIndex(indexName));
        }
        return copies;
    }

    public GlobalSecondaryIndex globalSecondaryIndex(String indexName) {
        if (!this.globalSecondaryIndexes.containsKey(indexName)) {
            return null;
        }
        GlobalSecondaryIndex gsi = this.globalSecondaryIndexes.get(indexName);
        GlobalSecondaryIndex.Builder copyBuilder = GlobalSecondaryIndex.builder().indexName(gsi.indexName()).projection((Projection)Projection.builder().projectionType(gsi.projection().projectionType()).build());
        for (KeySchemaElement key : gsi.keySchema()) {
            copyBuilder.keySchema((KeySchemaElement)KeySchemaElement.builder().attributeName(key.attributeName()).keyType(key.keyType()).build());
        }
        return (GlobalSecondaryIndex)copyBuilder.build();
    }

    public Collection<LocalSecondaryIndex> localSecondaryIndexes() {
        if (this.localSecondaryIndexes.isEmpty()) {
            return null;
        }
        ArrayList<LocalSecondaryIndex> copies = new ArrayList<LocalSecondaryIndex>(this.localSecondaryIndexes.size());
        for (String indexName : this.localSecondaryIndexes.keySet()) {
            copies.add(this.localSecondaryIndex(indexName));
        }
        return copies;
    }

    public LocalSecondaryIndex localSecondaryIndex(String indexName) {
        if (!this.localSecondaryIndexes.containsKey(indexName)) {
            return null;
        }
        LocalSecondaryIndex lsi = this.localSecondaryIndexes.get(indexName);
        LocalSecondaryIndex.Builder copyBuilder = LocalSecondaryIndex.builder().indexName(lsi.indexName()).projection((Projection)Projection.builder().projectionType(lsi.projection().projectionType()).build());
        for (KeySchemaElement key : lsi.keySchema()) {
            copyBuilder.keySchema((KeySchemaElement)KeySchemaElement.builder().attributeName(key.attributeName()).keyType(key.keyType()).build());
        }
        return (LocalSecondaryIndex)copyBuilder.build();
    }

    @Override
    public Map<String, AttributeValue> convert(T object) {
        LinkedHashMap<String, AttributeValue> map = new LinkedHashMap<String, AttributeValue>();
        for (DynamoDbMapperFieldModel<T, Object> field : this.fields()) {
            try {
                AttributeValue value = field.getAndConvert(object);
                if (value == null) continue;
                map.put(field.name(), value);
            }
            catch (RuntimeException e) {
                throw new DynamoDbMappingException(this.targetType.getSimpleName() + "[" + field.name() + "]; could not convert attribute", e);
            }
        }
        return map;
    }

    @Override
    public T unconvert(Map<String, AttributeValue> object) {
        T result = StandardBeanProperties.DeclaringReflect.newInstance(this.targetType);
        if (!object.isEmpty()) {
            for (DynamoDbMapperFieldModel<T, Object> field : this.fields()) {
                try {
                    AttributeValue value = object.get(field.name());
                    if (value == null) continue;
                    field.unconvertAndSet(result, value);
                }
                catch (RuntimeException e) {
                    throw new DynamoDbMappingException(this.targetType.getSimpleName() + "[" + field.name() + "]; could not unconvert attribute", e);
                }
            }
        }
        return result;
    }

    public <H, R> T createKey(H hashKey, R rangeKey) {
        T key = StandardBeanProperties.DeclaringReflect.newInstance(this.targetType);
        if (hashKey != null) {
            DynamoDbMapperFieldModel<T, H> hk = this.hashKey();
            hk.set(key, hashKey);
        }
        if (rangeKey != null) {
            DynamoDbMapperFieldModel<T, R> rk = this.rangeKey();
            rk.set(key, rangeKey);
        }
        return key;
    }

    public <H, R> Map<String, AttributeValue> convertKey(T key) {
        DynamoDbMapperFieldModel<T, H> hk = this.hashKey();
        DynamoDbMapperFieldModel<T, R> rk = this.rangeKeyIfExists();
        return this.convertKey(hk.get(key), rk == null ? null : (R)rk.get(key));
    }

    public <H, R> Map<String, AttributeValue> convertKey(H hashKey, R rangeKey) {
        Object rkValue;
        Object hkValue;
        LinkedHashMap<String, AttributeValue> key = new LinkedHashMap<String, AttributeValue>(4);
        DynamoDbMapperFieldModel<T, H> hk = this.hashKey();
        Object object = hkValue = hashKey == null ? null : hk.convert((Object)hashKey);
        if (hkValue == null) {
            throw new DynamoDbMappingException(this.targetType.getSimpleName() + "[" + hk.name() + "]; no HASH key value present");
        }
        key.put(hk.name(), (AttributeValue)hkValue);
        DynamoDbMapperFieldModel<T, R> rk = this.rangeKeyIfExists();
        Object object2 = rkValue = rangeKey == null ? null : rk.convert((Object)rangeKey);
        if (rkValue != null) {
            key.put(rk.name(), (AttributeValue)rkValue);
        } else if (rk != null) {
            throw new DynamoDbMappingException(this.targetType.getSimpleName() + "[" + rk.name() + "]; no RANGE key value present");
        }
        return key;
    }

    static class Builder<T> {
        private final Map<String, DynamoDbMapperFieldModel<T, Object>> versions = new LinkedHashMap<String, DynamoDbMapperFieldModel<T, Object>>(4);
        private final Map<String, DynamoDbMapperFieldModel<T, Object>> fields = new LinkedHashMap<String, DynamoDbMapperFieldModel<T, Object>>();
        private final Map<KeyType, DynamoDbMapperFieldModel<T, Object>> keys = new EnumMap<KeyType, DynamoDbMapperFieldModel<T, Object>>(KeyType.class);
        private final Properties properties;
        private final Class<T> targetType;

        public Builder(Class<T> targetType, Properties<T> properties) {
            this.properties = properties;
            this.targetType = targetType;
        }

        public Builder<T> with(DynamoDbMapperFieldModel<T, Object> field) {
            this.fields.put(field.name(), field);
            if (field.keyType() != null) {
                this.keys.put(field.keyType(), field);
            }
            if (field.versioned()) {
                this.versions.put(field.name(), field);
            }
            return this;
        }

        public Map<String, GlobalSecondaryIndex> globalSecondaryIndexes() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (DynamoDbMapperFieldModel<T, Object> field : this.fields.values()) {
                for (String indexName : field.globalSecondaryIndexNames(KeyType.HASH)) {
                    GlobalSecondaryIndex.Builder gsiBuilder = GlobalSecondaryIndex.builder().indexName(indexName).projection((Projection)Projection.builder().projectionType(ProjectionType.KEYS_ONLY).build()).keySchema((KeySchemaElement)KeySchemaElement.builder().attributeName(field.name()).keyType(KeyType.HASH).build());
                    if (map.put(indexName, gsiBuilder.build()) == null) continue;
                    throw new DynamoDbMappingException(this.targetType.getSimpleName() + "[" + field.name() + "]; must not duplicate GSI " + indexName);
                }
            }
            for (DynamoDbMapperFieldModel<T, Object> field : this.fields.values()) {
                for (String indexName : field.globalSecondaryIndexNames(KeyType.RANGE)) {
                    GlobalSecondaryIndex gsi = (GlobalSecondaryIndex)map.get(indexName);
                    if (gsi == null) {
                        throw new DynamoDbMappingException(this.targetType.getSimpleName() + "[" + field.name() + "]; no HASH key for GSI " + indexName);
                    }
                    map.put(indexName, gsi.toBuilder().keySchema((KeySchemaElement)KeySchemaElement.builder().attributeName(field.name()).keyType(KeyType.RANGE).build()).build());
                }
            }
            if (map.isEmpty()) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(map);
        }

        public Map<String, LocalSecondaryIndex> localSecondaryIndexes() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (DynamoDbMapperFieldModel<T, Object> field : this.fields.values()) {
                for (String indexName : field.localSecondaryIndexNames()) {
                    LocalSecondaryIndex.Builder lsiBuilder = LocalSecondaryIndex.builder().indexName(indexName).projection((Projection)Projection.builder().projectionType(ProjectionType.KEYS_ONLY).build()).keySchema((KeySchemaElement)KeySchemaElement.builder().attributeName(this.keys.get((Object)KeyType.HASH).name()).keyType(KeyType.HASH).build(), (KeySchemaElement)KeySchemaElement.builder().attributeName(field.name()).keyType(KeyType.RANGE).build());
                    if (map.put(indexName, lsiBuilder.build()) == null) continue;
                    throw new DynamoDbMappingException(this.targetType.getSimpleName() + "[" + field.name() + "]; must not duplicate LSI " + indexName);
                }
            }
            if (map.isEmpty()) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(map);
        }

        private Map<String, DynamoDbMapperFieldModel<T, Object>> versions() {
            if (this.versions.isEmpty()) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(this.versions);
        }

        public Map<String, DynamoDbMapperFieldModel<T, Object>> fields() {
            if (this.fields.isEmpty()) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(this.fields);
        }

        public Map<KeyType, DynamoDbMapperFieldModel<T, Object>> keys() {
            if (this.keys.isEmpty()) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(this.keys);
        }

        public DynamoDbMapperTableModel<T> build() {
            DynamoDbMapperTableModel result = new DynamoDbMapperTableModel(this);
            if (this.properties.tableName() != null) {
                result.hashKey();
            }
            return result;
        }
    }

    static interface Properties<T> {
        public String tableName();

        public static final class Immutable<T>
        implements Properties<T> {
            private final String tableName;

            public Immutable(Properties<T> properties) {
                this.tableName = properties.tableName();
            }

            @Override
            public String tableName() {
                return this.tableName;
            }
        }
    }
}

