/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Date;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAutoGenerateStrategy;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAutoGenerated;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAutoGenerator;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverter;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardTypeConverters;

@DynamoDbAutoGenerated(generator=Generator.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
public @interface DynamoDbAutoGeneratedTimestamp {
    public DynamoDbAutoGenerateStrategy strategy() default DynamoDbAutoGenerateStrategy.ALWAYS;

    public static final class Generator<T>
    extends DynamoDbAutoGenerator.AbstractGenerator<T> {
        private final DynamoDbTypeConverter<T, Date> converter;

        public Generator(Class<T> targetType, DynamoDbAutoGeneratedTimestamp annotation) {
            super(annotation.strategy());
            this.converter = StandardTypeConverters.factory().getConverter(targetType, Date.class);
        }

        @Override
        public final T generate(T currentValue) {
            return this.converter.convert(new Date());
        }
    }
}

