/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.core;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.TransformIterator;

@SdkInternalApi
public class TransformIterable<T, R>
implements Iterable<R> {
    private final Iterable<T> wrappedIterable;
    private final Function<T, R> transformFunction;

    private TransformIterable(Iterable<T> wrappedIterable, Function<T, R> transformFunction) {
        this.wrappedIterable = wrappedIterable;
        this.transformFunction = transformFunction;
    }

    public static <T, R> TransformIterable<T, R> of(Iterable<T> iterable, Function<T, R> transformFunction) {
        return new TransformIterable<T, R>(iterable, transformFunction);
    }

    @Override
    public Iterator<R> iterator() {
        return TransformIterator.of(this.wrappedIterable.iterator(), this.transformFunction);
    }
}

