/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.extensions;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Expression;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.extensions.ReadModification;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.extensions.WriteModification;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
public class ChainMapperExtension
implements MapperExtension {
    private final Deque<MapperExtension> extensionChain;

    private ChainMapperExtension(List<MapperExtension> mapperExtensions) {
        this.extensionChain = new ArrayDeque<MapperExtension>(mapperExtensions);
    }

    public static ChainMapperExtension of(MapperExtension ... mapperExtensions) {
        return new ChainMapperExtension(Arrays.asList(mapperExtensions));
    }

    @Override
    public WriteModification beforeWrite(Map<String, AttributeValue> item, OperationContext operationContext, TableMetadata tableMetadata) {
        AtomicReference transformedItem = new AtomicReference();
        AtomicReference conditionalExpression = new AtomicReference();
        this.extensionChain.forEach(extension -> {
            Map itemToTransform = transformedItem.get() == null ? item : (Map)transformedItem.get();
            WriteModification writeModification = extension.beforeWrite(itemToTransform, operationContext, tableMetadata);
            if (writeModification.getTransformedItem() != null) {
                transformedItem.set(writeModification.getTransformedItem());
            }
            if (writeModification.getAdditionalConditionalExpression() != null) {
                if (conditionalExpression.get() == null) {
                    conditionalExpression.set(writeModification.getAdditionalConditionalExpression());
                } else {
                    conditionalExpression.set(Expression.coalesce((Expression)conditionalExpression.get(), writeModification.getAdditionalConditionalExpression(), " AND "));
                }
            }
        });
        return WriteModification.builder().transformedItem((Map)transformedItem.get()).additionalConditionalExpression((Expression)conditionalExpression.get()).build();
    }

    @Override
    public ReadModification afterRead(Map<String, AttributeValue> item, OperationContext operationContext, TableMetadata tableMetadata) {
        AtomicReference transformedItem = new AtomicReference();
        this.extensionChain.descendingIterator().forEachRemaining(extension -> {
            Map itemToTransform = transformedItem.get() == null ? item : (Map)transformedItem.get();
            ReadModification readModification = extension.afterRead(itemToTransform, operationContext, tableMetadata);
            if (readModification.getTransformedItem() != null) {
                transformedItem.set(readModification.getTransformedItem());
            }
        });
        return ReadModification.builder().transformedItem((Map)transformedItem.get()).build();
    }
}

