/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.extensions;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Expression;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
public class WriteModification {
    private final Map<String, AttributeValue> transformedItem;
    private final Expression additionalConditionalExpression;

    private WriteModification(Map<String, AttributeValue> transformedItem, Expression additionalConditionalExpression) {
        this.transformedItem = transformedItem;
        this.additionalConditionalExpression = additionalConditionalExpression;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, AttributeValue> getTransformedItem() {
        return this.transformedItem;
    }

    public Expression getAdditionalConditionalExpression() {
        return this.additionalConditionalExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteModification that = (WriteModification)o;
        if (this.transformedItem != null ? !this.transformedItem.equals(that.transformedItem) : that.transformedItem != null) {
            return false;
        }
        return this.additionalConditionalExpression != null ? this.additionalConditionalExpression.equals(that.additionalConditionalExpression) : that.additionalConditionalExpression == null;
    }

    public int hashCode() {
        int result = this.transformedItem != null ? this.transformedItem.hashCode() : 0;
        result = 31 * result + (this.additionalConditionalExpression != null ? this.additionalConditionalExpression.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private Map<String, AttributeValue> transformedItem;
        private Expression additionalConditionalExpression;

        private Builder() {
        }

        public Builder transformedItem(Map<String, AttributeValue> transformedItem) {
            this.transformedItem = transformedItem;
            return this;
        }

        public Builder additionalConditionalExpression(Expression additionalConditionalExpression) {
            this.additionalConditionalExpression = additionalConditionalExpression;
            return this;
        }

        public WriteModification build() {
            return new WriteModification(this.transformedItem, this.additionalConditionalExpression);
        }
    }
}

