/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient;

import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkPublicApi
public interface DatabaseOperation<RequestT, ResponseT, ResultT> {
    public RequestT generateRequest(MapperExtension var1);

    public Function<RequestT, ResponseT> getServiceCall(DynamoDbClient var1);

    public ResultT transformResponse(ResponseT var1, MapperExtension var2);

    default public ResultT execute(DynamoDbClient dynamoDbClient, MapperExtension mapperExtension) {
        RequestT request = this.generateRequest(mapperExtension);
        ResponseT response = this.getServiceCall(dynamoDbClient).apply(request);
        return this.transformResponse(response, mapperExtension);
    }
}

