/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Expression;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Page;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.TransformIterable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.QueryConditional;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.paginators.QueryIterable;

@SdkPublicApi
public class Query<T>
implements TableOperation<T, QueryRequest, QueryIterable, Iterable<Page<T>>> {
    private final QueryConditional queryConditional;
    private final Map<String, AttributeValue> exclusiveStartKey;
    private final Boolean scanIndexForward;
    private final Integer limit;
    private final Boolean consistentRead;
    private final Expression filterExpression;

    private Query(QueryConditional queryConditional, Map<String, AttributeValue> exclusiveStartKey, Boolean scanIndexForward, Integer limit, Boolean consistentRead, Expression filterExpression) {
        this.queryConditional = queryConditional;
        this.exclusiveStartKey = exclusiveStartKey;
        this.scanIndexForward = scanIndexForward;
        this.limit = limit;
        this.consistentRead = consistentRead;
        this.filterExpression = filterExpression;
    }

    public static <T> Query<T> of(QueryConditional queryConditional) {
        return new Query<T>(queryConditional, null, null, null, null, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().queryConditional(this.queryConditional).exclusiveStartKey(this.exclusiveStartKey).scanIndexForward(this.scanIndexForward).limit(this.limit).consistentRead(this.consistentRead).filterExpression(this.filterExpression);
    }

    @Override
    public QueryRequest generateRequest(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        Expression queryExpression = this.queryConditional.getExpression(tableSchema, operationContext.getIndexName());
        Map<String, AttributeValue> expressionValues = queryExpression.getExpressionValues();
        Map<String, String> expressionNames = queryExpression.getExpressionNames();
        if (this.filterExpression != null) {
            expressionValues = Expression.coalesceValues(expressionValues, this.filterExpression.getExpressionValues());
            expressionNames = Expression.coalesceNames(expressionNames, this.filterExpression.getExpressionNames());
        }
        QueryRequest.Builder queryRequest = QueryRequest.builder().tableName(operationContext.getTableName()).keyConditionExpression(queryExpression.getExpression()).expressionAttributeValues(expressionValues).expressionAttributeNames(expressionNames).scanIndexForward(this.scanIndexForward).limit(this.limit).exclusiveStartKey(this.exclusiveStartKey).consistentRead(this.consistentRead);
        if (!TableMetadata.getPrimaryIndexName().equals(operationContext.getIndexName())) {
            queryRequest = queryRequest.indexName(operationContext.getIndexName());
        }
        if (this.filterExpression != null) {
            queryRequest = queryRequest.filterExpression(this.filterExpression.getExpression());
        }
        return (QueryRequest)queryRequest.build();
    }

    @Override
    public Iterable<Page<T>> transformResponse(QueryIterable response, TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        return TransformIterable.of(response, this.getQueryResponseMapper(tableSchema, operationContext, mapperExtension));
    }

    @Override
    public Function<QueryRequest, QueryIterable> getServiceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).queryPaginator(arg_0);
    }

    private Function<QueryResponse, Page<T>> getQueryResponseMapper(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        return Utils.readAndTransformPaginatedItems(tableSchema, operationContext, mapperExtension, QueryResponse::items, QueryResponse::lastEvaluatedKey);
    }

    public QueryConditional getQueryConditional() {
        return this.queryConditional;
    }

    public Map<String, AttributeValue> getExclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public Boolean getScanIndexForward() {
        return this.scanIndexForward;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Boolean getConsistentRead() {
        return this.consistentRead;
    }

    public Expression getFilterExpression() {
        return this.filterExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        if (this.queryConditional != null ? !this.queryConditional.equals(query.queryConditional) : query.queryConditional != null) {
            return false;
        }
        if (this.exclusiveStartKey != null ? !this.exclusiveStartKey.equals(query.exclusiveStartKey) : query.exclusiveStartKey != null) {
            return false;
        }
        if (this.scanIndexForward != null ? !this.scanIndexForward.equals(query.scanIndexForward) : query.scanIndexForward != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(query.limit) : query.limit != null) {
            return false;
        }
        if (this.consistentRead != null ? !this.consistentRead.equals(query.consistentRead) : query.consistentRead != null) {
            return false;
        }
        return this.filterExpression != null ? this.filterExpression.equals(query.filterExpression) : query.filterExpression == null;
    }

    public int hashCode() {
        int result = this.queryConditional != null ? this.queryConditional.hashCode() : 0;
        result = 31 * result + (this.exclusiveStartKey != null ? this.exclusiveStartKey.hashCode() : 0);
        result = 31 * result + (this.scanIndexForward != null ? this.scanIndexForward.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.consistentRead != null ? this.consistentRead.hashCode() : 0);
        result = 31 * result + (this.filterExpression != null ? this.filterExpression.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private QueryConditional queryConditional;
        private Map<String, AttributeValue> exclusiveStartKey;
        private Boolean scanIndexForward;
        private Integer limit;
        private Boolean consistentRead;
        private Expression filterExpression;

        private Builder() {
        }

        public <T> Query<T> build() {
            return new Query(this.queryConditional, this.exclusiveStartKey, this.scanIndexForward, this.limit, this.consistentRead, this.filterExpression);
        }

        public Builder queryConditional(QueryConditional queryConditional) {
            this.queryConditional = queryConditional;
            return this;
        }

        public Builder scanIndexForward(Boolean scanIndexForward) {
            this.scanIndexForward = scanIndexForward;
            return this;
        }

        public Builder exclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
            this.exclusiveStartKey = exclusiveStartKey;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public Builder filterExpression(Expression filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }
    }
}

