/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.mapper;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.ExecutionContext;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.IndexValidator;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticImmutableTableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.WrappedTableSchema;

@SdkPublicApi
@ThreadSafe
public final class StaticTableSchema<T>
extends WrappedTableSchema<T, StaticImmutableTableSchema<T, T>> {
    private StaticTableSchema(Builder<T> builder) {
        super(((Builder)builder).delegateBuilder.build());
    }

    public static <T> Builder<T> builder(Class<T> itemClass) {
        return new Builder(EnhancedType.of(itemClass));
    }

    public static <T> Builder<T> builder(EnhancedType<T> itemType) {
        return new Builder(itemType);
    }

    private StaticImmutableTableSchema<T, T> toImmutableTableSchema() {
        return (StaticImmutableTableSchema)this.delegateTableSchema();
    }

    public AttributeConverterProvider attributeConverterProvider() {
        return ((StaticImmutableTableSchema)this.delegateTableSchema()).attributeConverterProvider();
    }

    @NotThreadSafe
    public static final class Builder<T> {
        private final StaticImmutableTableSchema.Builder<T, T> delegateBuilder;
        private final EnhancedType<T> itemType;

        private Builder(EnhancedType<T> itemType) {
            this.delegateBuilder = StaticImmutableTableSchema.builder(itemType, itemType);
            this.itemType = itemType;
        }

        public Builder<T> newItemSupplier(Supplier<T> newItemSupplier) {
            this.delegateBuilder.newItemBuilder(newItemSupplier, Function.identity());
            return this;
        }

        @SafeVarargs
        public final Builder<T> attributes(StaticAttribute<T, ?> ... staticAttributes) {
            this.delegateBuilder.attributes(Arrays.stream(staticAttributes).map(StaticAttribute::toImmutableAttribute).collect(Collectors.toList()));
            return this;
        }

        public Builder<T> attributes(Collection<StaticAttribute<T, ?>> staticAttributes) {
            this.delegateBuilder.attributes(staticAttributes.stream().map(StaticAttribute::toImmutableAttribute).collect(Collectors.toList()));
            return this;
        }

        public <R> Builder<T> addAttribute(EnhancedType<R> attributeType, Consumer<StaticAttribute.Builder<T, R>> staticAttribute) {
            StaticAttribute.Builder<T, R> builder = StaticAttribute.builder(this.itemType, attributeType);
            staticAttribute.accept(builder);
            this.delegateBuilder.addAttribute(builder.build().toImmutableAttribute());
            return this;
        }

        public <R> Builder<T> addAttribute(Class<R> attributeClass, Consumer<StaticAttribute.Builder<T, R>> staticAttribute) {
            StaticAttribute.Builder<T, R> builder = StaticAttribute.builder(this.itemType, EnhancedType.of(attributeClass));
            staticAttribute.accept(builder);
            this.delegateBuilder.addAttribute(builder.build().toImmutableAttribute());
            return this;
        }

        public Builder<T> addAttribute(StaticAttribute<T, ?> staticAttribute) {
            this.delegateBuilder.addAttribute(staticAttribute.toImmutableAttribute());
            return this;
        }

        public <R> Builder<T> flatten(TableSchema<R> otherTableSchema, Function<T, R> otherItemGetter, BiConsumer<T, R> otherItemSetter) {
            this.delegateBuilder.flatten(otherTableSchema, otherItemGetter, otherItemSetter);
            return this;
        }

        public <R> Builder<T> flatten(String mapName, Function<T, Map<String, String>> mapItemGetter, BiConsumer<T, Map<String, String>> mapItemSetter) {
            this.delegateBuilder.flatten(mapName, mapItemGetter, mapItemSetter);
            return this;
        }

        public Builder<T> extend(StaticTableSchema<? super T> superTableSchema) {
            this.delegateBuilder.extend(((StaticTableSchema)superTableSchema).toImmutableTableSchema());
            return this;
        }

        public Builder<T> tags(StaticTableTag ... staticTableTags) {
            this.delegateBuilder.tags(staticTableTags);
            return this;
        }

        public Builder<T> tags(Collection<StaticTableTag> staticTableTags) {
            this.delegateBuilder.tags(staticTableTags);
            return this;
        }

        public Builder<T> addTag(StaticTableTag staticTableTag) {
            this.delegateBuilder.addTag(staticTableTag);
            return this;
        }

        public Builder<T> attributeConverterProviders(AttributeConverterProvider ... attributeConverterProviders) {
            this.delegateBuilder.attributeConverterProviders(attributeConverterProviders);
            return this;
        }

        public Builder<T> attributeConverterProviders(List<AttributeConverterProvider> attributeConverterProviders) {
            this.delegateBuilder.attributeConverterProviders(attributeConverterProviders);
            return this;
        }

        public StaticTableSchema<T> build() {
            return this.build(ExecutionContext.ROOT);
        }

        public StaticTableSchema<T> build(ExecutionContext context) {
            StaticTableSchema staticTableSchema = new StaticTableSchema(this);
            if (context == ExecutionContext.ROOT) {
                IndexValidator.validateAllIndices(staticTableSchema.tableMetadata().indices());
            }
            return staticTableSchema;
        }
    }
}

