/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.conditional;

import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.conditional.QueryConditionalUtils;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public class BeginsWithConditional
implements QueryConditional {
    private static final String BEGINS_WITH_NUMERIC_SORT_KEY_ERROR = "Attempt to query using a 'beginsWith' condition operator against a numeric sort key. Index: %s, Attribute: %s";
    private final Key key;

    public BeginsWithConditional(Key key) {
        this.key = key;
    }

    @Override
    public Expression expression(TableSchema<?> tableSchema, String indexName) {
        QueryConditionalUtils.KeyResolution keyResolution = QueryConditionalUtils.resolveKeys(this.key, tableSchema, indexName);
        this.validateBeginsWithConstraints(keyResolution, indexName);
        return this.buildBeginsWithExpression(keyResolution);
    }

    private void validateBeginsWithConstraints(QueryConditionalUtils.KeyResolution keyResolution, String indexName) {
        QueryConditionalUtils.validatePartitionKeyConstraints(keyResolution, indexName);
        QueryConditionalUtils.validateSortKeyConstraints(keyResolution, indexName);
        if (keyResolution.sortValues.isEmpty()) {
            throw new IllegalArgumentException(String.format("A query conditional requires a sort key to compare with, however one was not provided. Index: %s", indexName));
        }
        AttributeValue rightmostSortValue = keyResolution.getRightmostSortValue();
        if (rightmostSortValue.n() != null) {
            throw new IllegalArgumentException(String.format(BEGINS_WITH_NUMERIC_SORT_KEY_ERROR, indexName, keyResolution.getRightmostSortKey()));
        }
    }

    private Expression buildBeginsWithExpression(QueryConditionalUtils.KeyResolution keyResolution) {
        StringBuilder expression = new StringBuilder();
        HashMap<String, String> names = new HashMap<String, String>();
        HashMap<String, AttributeValue> values = new HashMap<String, AttributeValue>();
        QueryConditionalUtils.addPartitionKeyConditions(expression, names, values, keyResolution.partitionKeys, keyResolution.partitionValues);
        QueryConditionalUtils.addNonRightmostSortKeyConditions(expression, names, values, keyResolution.sortKeys, keyResolution.sortValues);
        this.addBeginsWithCondition(expression, names, values, keyResolution);
        return QueryConditionalUtils.buildExpression(expression, names, values);
    }

    private void addBeginsWithCondition(StringBuilder expression, Map<String, String> names, Map<String, AttributeValue> values, QueryConditionalUtils.KeyResolution keyResolution) {
        String rightmostSortKey = keyResolution.getRightmostSortKey();
        AttributeValue rightmostSortValue = keyResolution.getRightmostSortValue();
        String keyToken = EnhancedClientUtils.keyRef(rightmostSortKey);
        String valueToken = EnhancedClientUtils.valueRef(rightmostSortKey);
        expression.append(" AND ").append("begins_with(").append(keyToken).append(", ").append(valueToken).append(")");
        names.put(keyToken, rightmostSortKey);
        values.put(valueToken, rightmostSortValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeginsWithConditional that = (BeginsWithConditional)o;
        return this.key != null ? this.key.equals(that.key) : that.key == null;
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }
}

