/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.mapper;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.IndexMetadata;
import software.amazon.awssdk.enhanced.dynamodb.KeyAttributeMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.mapper.Order;

@SdkInternalApi
@ThreadSafe
final class IndexValidator {
    private static final int MIN_KEY_ORDER = -1;
    private static final int MAX_KEY_ORDER = 3;
    private static final int IMPLICIT_ORDER = -1;
    private static final String DUPLICATE_KEY_MSG = "Attempt to set an index key that conflicts with an existing index key of the same name and index. Index name: %s; attribute name: %s)";
    private static final String DUPLICATE_ATTRIBUTE_MSG = "Duplicate %s key '%s' for index '%s'";
    private static final String INVALID_ORDER_MSG = "Key order must be between %d and %d, got: %d";
    private static final String COMPOSITE_ORDERING_MSG = "Composite %s keys for index '%s' must all have explicit ordering (0,1,2,3)";
    private static final String NON_COMPOSITE_ORDERING_MSG = "Invalid non-composite %s key order for index '%s'. Expected: -1,0 but got: %s";
    private static final String DUPLICATE_ORDER_MSG = "Duplicate %s key order %d for index '%s'";
    private static final String NON_SEQUENTIAL_MSG = "Non-sequential %s key orders for index '%s'. Expected: 0,1,2,3 but got: %s";

    private IndexValidator() {
    }

    static void validateKeyOrder(Order order) {
        if (order.getIndex() < -1 || order.getIndex() > 3) {
            throw new IllegalArgumentException(String.format(INVALID_ORDER_MSG, -1, 3, order.getIndex()));
        }
    }

    static void validateNoDuplicateKeys(List<KeyAttributeMetadata> keys, String indexName, String attributeName) {
        if (keys.stream().anyMatch(k -> k.name().equals(attributeName))) {
            throw new IllegalArgumentException(String.format(DUPLICATE_KEY_MSG, indexName, attributeName));
        }
    }

    static void validateAllIndices(Collection<IndexMetadata> indices) {
        for (IndexMetadata index : indices) {
            if (TableMetadata.primaryIndexName().equals(index.name())) continue;
            IndexValidator.validateCompositeKeyOrdering(index.partitionKeys(), "partition", index.name());
            IndexValidator.validateCompositeKeyOrdering(index.sortKeys(), "sort", index.name());
        }
    }

    static void validateCompositeKeyOrdering(List<KeyAttributeMetadata> keys, String keyType, String indexName) {
        if (keys.size() <= 1) {
            int order;
            if (keys.size() == 1 && (order = keys.get(0).order().getIndex()) != -1 && order != 0) {
                throw new IllegalArgumentException(String.format(NON_COMPOSITE_ORDERING_MSG, keyType, indexName, order));
            }
            return;
        }
        HashSet<String> seenNames = new HashSet<String>();
        HashSet<Integer> seenOrders = new HashSet<Integer>();
        boolean[] orderPresent = new boolean[keys.size()];
        for (KeyAttributeMetadata key2 : keys) {
            String name = key2.name();
            int order = key2.order().getIndex();
            if (!seenNames.add(name)) {
                throw new IllegalArgumentException(String.format(DUPLICATE_ATTRIBUTE_MSG, keyType, name, indexName));
            }
            if (order == -1) {
                throw new IllegalArgumentException(String.format(COMPOSITE_ORDERING_MSG, keyType, indexName));
            }
            if (!seenOrders.add(order)) {
                throw new IllegalArgumentException(String.format(DUPLICATE_ORDER_MSG, keyType, order, indexName));
            }
            if (order < 0 || order >= keys.size()) continue;
            orderPresent[order] = true;
        }
        for (int i = 0; i < keys.size(); ++i) {
            if (orderPresent[i]) continue;
            List actualOrders = keys.stream().map(key -> key.order().getIndex()).sorted().collect(Collectors.toList());
            throw new IllegalArgumentException(String.format(NON_SEQUENTIAL_MSG, keyType, indexName, actualOrders));
        }
    }
}

